/*                                 */
/*  token.c -- ȡڤФ  */
/*                                 */
/*  sh2pad  by S. Yoshida          */
/*                                 */

#include "config.h"

#include <string.h>
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#include <ctype.h>
#include "sh2pad.h"
#include "lib.h"

static int ch = 0;
static int pch = 0;		/* ʸɤ */
static int word_ptr = 0;	/* word ΰ */
static bool newline = On;	/* Ƭɤ */
static bool comm_flag = Off;	/* Ȥ椫 */

static void set_ch(void);
static void append_ch(void);
static void get_ch(void);
static int p_getchar(FILE *);

void get_token(void)
/* ȡڤФ */
{
    if(token == Eof)
	fatal_error("input file terminates unexpectedly.");

    if(ch == 0)
	get_ch();

    if(cat_flag > 0){
	if(ch == '\n')
	    token = Ret;
	else{
	    token = Str;
	    *word = ch;
	    *(word+1) = '\0';
	}
	get_ch();
	return;
    }

    switch(ch){
	case EOF:
	    token = Eof;
	    *word = '\0';
	    return;
	case 1:
	    token = Wsemicolon;
	    *word = ';';
	    *(word+1) = '\0';
	    get_ch();
	    return;
	case '\n':
	    newline = On;
	    token = Ret;
	    *word = ' ';
	    *(word+1) = '\0';
	    get_ch();
	    cat_flag = strlen(key);
	    return;
	case ' ':
	case '\t':
	    token = Sp;
	    set_ch();
	    get_ch();
	    while(ch == ' '  ||  ch == '\t'){
		append_ch();
		get_ch();
	    }
	    return;
	case '#':
	    comm_flag = On;
	    set_ch();
	    get_ch();
	    while(ch != '\n'){
		append_ch();
		get_ch();
	    }

	    /* ξǤϽϤʤ */
	    if (no_print_comment_flag == On) {
		char buf[BUFSIZ];
		strcpy(buf,"// ");
		strcat(buf,word);
		comm_flag = Off;

		if(word[strlen(word)-1] == '\\'  ||  newline == On){
		    set_ch();
		    get_ch();
		}else{
		    cat_flag = strlen(key);
		}

		newline = On;
		strcpy(word,buf);
		token = Comment;
		return;
	    }

	    print("// ");
	    print(word);
	    print("\n");
	    comm_flag = Off;
	    set_ch();
	    get_ch();
	    if(word[strlen(word)-1] != '\\'  &&  newline != On){	/* ƬΥȤǤʤв */
		newline = On;
		token = Ret;
		cat_flag = strlen(key);
	    }else{
		newline = On;
		get_token();
	    }
	    return;
	case '"':
	    newline = Off;
	    set_ch();

	    do{
		get_ch();
		if(ch == '\n'){
		    ch = '\\'; append_ch();
		    ch = 'n'; append_ch();
		}else if(ch == '\\'){
		    append_ch();
		    get_ch(); append_ch();
		    ch = ' ';
		}else
		    append_ch();
	    }while(ch != '"');

	    get_ch();

	    token = Str;
	    return;
	case '\'':
	    newline = Off;
	    set_ch();

	    do{
		get_ch();
		if(ch == '\n'){
		    ch = '\\'; append_ch();
		    ch = 'n'; append_ch();
		}else if(ch == '\\'){
		    append_ch();
		    get_ch(); append_ch();
		    ch = ' ';
		}else
		    append_ch();
	    }while(ch != '\'');

	    get_ch();

	    token = Str;
	    return;
	case '`':
	    newline = Off;
	    set_ch();

	    do{
		get_ch();
		if(ch == '\n'){
		    ch = '\\'; append_ch();
		    ch = 'n'; append_ch();
		}else if(ch == '\\'){
		    append_ch();
		    get_ch(); append_ch();
		    ch = ' ';
		}else
		    append_ch();
	    }while(ch != '`');

	    get_ch();

	    token = Str;
	    return;
	case '&':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if (ch == '&') {
		token = And2;
		append_ch();
		get_ch();
	    } else
		token = Str;
	    return;
	case '|':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if (ch == '|') {
		token = Or2;
		append_ch();
		get_ch();
	    } else
		token = Str;
	    return;
	case '<':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if (ch == '<') {
		token = LL;
		append_ch();
		get_ch();
	    } else
		token = Str;
	    return;
	case '\\':
	    newline = Off;
	    token = Str;
	    set_ch();
	    get_ch();
	    append_ch();
	    get_ch();
	    return;
	case '$':
	    newline = Off;
	    token = Str;
	    set_ch();
	    get_ch();
	    if(ch == '#'){
		append_ch();
		get_ch();
	    } else if(ch == '{'){
		append_ch();
		get_ch();
		token = Lbrace;
	    }
	    return;
	case '(':
	    newline = Off;
	    global_count_paren--;
	    token = Lpar;
	    set_ch();
	    get_ch();
	    return;
	case ')':
	    newline = Off;
	    global_count_paren++;
	    token = Rpar;
	    set_ch();
	    get_ch();
	    return;
	case '{':
	    newline = Off;
	    token = Plbrace;
	    set_ch();
	    get_ch();
	    return;
	case '}':
	    newline = Off;
	    token = Rbrace;
	    set_ch();
	    get_ch();
	    return;
	case '[':
	    newline = Off;
	    token = Lbracket;
	    set_ch();
	    get_ch();
	    return;
	case ']':
	    newline = Off;
	    token = Rbracket;
	    set_ch();
	    get_ch();
	    return;
	case ';':
	    newline = Off;
	    token = Semicolon;
	    set_ch();
	    get_ch();
	    if(ch == ';')
		ch = 1;		/* ;; */
	    return;
	default:
	    if(isdigit(ch)){
		token = Num;
		set_ch();
		get_ch();
		while(isdigit(ch)){
		    append_ch();
		    get_ch();
		}
		newline = Off;
		return;
	    }

	    if(isalpha(ch)  ||  ch == '_'){
		token = Name;
		set_ch();
		get_ch();
		while(isalnum(ch)  ||  (char)ch == '_'){
		    append_ch();
		    get_ch();
		}

		if(strcmp(word,"if") == 0)
		    token = If;
		else if(strcmp(word,"then") == 0)
		    token = Then;
		else if(strcmp(word,"else") == 0)
		    token = Else;
		else if(strcmp(word,"elif") == 0)
		    token = Elif;
		else if(strcmp(word,"fi") == 0)
		    token = Fi;
		else if(strcmp(word,"for") == 0)
		    token = For;
		else if(strcmp(word,"while") == 0)
		    token = While;
		else if(strcmp(word,"do") == 0)
		    token = Do;
		else if(strcmp(word,"done") == 0)
		    token = Done;
		else if(strcmp(word,"case") == 0)
		    token = Case;
		else if(strcmp(word,"in") == 0)
		    token = In;
		else if(strcmp(word,"esac") == 0)
		    token = Esac;
		else if(strcmp(word,"function") == 0)
		    token = Function;

		newline = Off;
		return;
	    }

	    token = Str;
	    set_ch();
	    get_ch();
	    newline = Off;
	    return;
    }
}

void set_ch(void)
/* ɤʸΥå */
{
    *word = ch;
    *(word + 1) = '\0';
    word_ptr = 1;
}

void append_ch(void)
/* ɤʸɲ */
{
    *(word + word_ptr) = ch;
    *(word + word_ptr + 1) = '\0';
    word_ptr++;
}

void get_ch(void)
/* ʸɤ */
{
    if(ch == 0){
	ch = p_getchar(input_stream);
	pch = p_getchar(input_stream);
    }else{
	ch = pch;
	pch = p_getchar(input_stream);
    }

    if(comm_flag == Off  &&  
       ch == '\\'  &&  pch == '\n'){	/* ʸ '\' ɤ߼ΤƤ */
	line_count++;
	ch = p_getchar(input_stream);
	pch = p_getchar(input_stream);
    }

    if(ch == '\n')
	line_count++;
}

int p_getchar(FILE *fp)
/* ʸɤ߹ */
{
    int c = 0;
    while(((0 <= c  &&  c < ' '  &&  c != '\t'  &&  c != '\n')  ||  c == 0x7F)  &&  c != EOF){
	c = getc(fp);
    }
    return c;
}
