/*                         */
/*  sh2pad.h               */
/*                         */
/*  sh2pad  by S. Yoshida  */
/*                         */

#ifndef _SH2PAD_H
#define _SH2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* ̵ϱѸǤ */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num, Function,
    And2, Or2, LL,
    Lpar, Rpar, Plbrace, Lbrace, Rbrace, Lbracket, Rbracket,
    Semicolon, Wsemicolon,
    If, Then, Else, Elif, Fi, For, While, Do, Done,
    Case, In, Esac
} token_type;

typedef struct _NEST NEST;
typedef struct _STR STR;

struct _NEST {
    NEST *parent;
    NEST *child;
    STR *strr;
    STR *strl;
    int nest_level;
};    

struct _STR {
    char *str;
    STR *next;
};


extern token_type token;	/* ȡ */
extern char word[];		/* ɤʸ */

extern bool no_print_comment_flag;	/* Ȥ򤽤ξɽʤ */

extern int tab;			/*  */
extern int global_count_paren;	/* ̤б */

extern char key[];		/* cat << EOF νλʸ */
extern int cat_flag;		/* cat << EOF 椫 */

extern NEST *nest;		/* ؿΥͥ */
extern NEST *child;		/* Ҵؿ */

extern bool debug;		/* -debug ץ */
extern bool quiet;		/* -quiet ץ */
extern bool print_warning;	/* warningϤ뤫 */
extern int line_count;		/* Ƥ */

extern FILE *input_stream;	/* ϥե */


/* parser.c */
extern void parser(void);		/*  */
extern void print(const char *);	/* ʸ */

/* token.c */
extern void get_token(void);		/* ȡڤФ */

#endif  /* ! _SH2PAD_H */
