/*                               */
/*  tex.c -- LaTeX ɤν  */
/*                               */
/*  pad2ps  by S. Yoshida        */
/*                               */

#include "config.h"

#include <ctype.h>
#include "pad2ps.h"

static int tab;
static char *padtitle = NULL;
static bool case_flag = Off;
static bool nostack = Off;

static void make_tex(void);
static void begin_tex(void);
static void end_tex(void);
static void print(char *);
static void print_tab(void);

static void body(PAD *);
static void commands(PAD *);
static void command(PAD *);
static void block_statement(PAD *p);
static void refer_statement(PAD *p);
static void repeat_statement(PAD *p);
static void branch_statement(PAD *p);
static void if_statement(PAD *p);
static void switch_statement(PAD *p);

static int is_controlcode(TYPE);

void tex(void)
/* LaTeX ɤκ */
{
#ifdef DEBUG
    if(quiet == Off)
        fprintf(stderr,"Making LaTeX code starts...");
#endif

    if(figure_locate_flag == Off)	/* figure_locate Υǥե */
	figure_locate = Bottom;

    if(outfile[0] != '\0')
	fp = fopen(outfile,"w");

    begin_tex();
    make_tex();
    end_tex();

    if(outfile[0] != '\0')
	fclose(fp);

#ifdef DEBUG
    if(quiet == Off)
        fprintf(stderr,"done\n");
#endif
}

void make_tex(void)
{
    PAD *ptr;

    for(ptr = root->next ; ptr != NULL ; ptr = ptr->next){
	if( ! is_controlcode(ptr->type))
	    body(ptr);
    }
}

void begin_tex(void)
{
    fputs("%\n",fp);
    fputs("% pad2ps LaTeX output\n",fp);
    fprintf(fp,"%%   %s\n",AUTHOR);
    fputs("%\n",fp);
    putc('\n',fp);
#ifdef ENGLISH
    fputs("\\documentstyle[pad]{article}\n",fp);
#endif
#ifdef JAPANESE
    fputs("\\documentstyle[pad]{jarticle}\n",fp);
#endif

    if(title != NULL){			/* 祿ȥ뤬 */
	fprintf(fp,"\\title{");
	nostack = On;
	print(title);
	nostack = Off;
	fputs("}\n",fp);
	fputs("\\author{}\n",fp);
	fputs("\\date{}\n",fp);
    }

    fputs("\\fboxsep=10pt\n",fp);
    putc('\n',fp);

    fputs("\\begin{document}\n",fp);

    if(title != NULL)			/* 祿ȥν */
	fputs("\\maketitle\n",fp);

    if(page_print == On)		/* ڡֹν */
	fprintf(fp,"\\setcounter{page}{%d}\n",page + 1);
    else{
	fputs("\\thispagestyle{empty}\n",fp);
	fputs("\\pagestyle{empty}\n",fp);
    }

    if(figure != EOF)			/* ֹν */
	fprintf(fp,"\\setcounter{figure}{%d}\n",figure - 1);

    putc('\n',fp);
}

void end_tex(void)
{
    fputs("\\end{document}\n",fp);
    putc('\n',fp);
    fputs("% End of pad2ps LaTeX output\n",fp);
}

void print(char *s)
/* ʸν */
{
    char *p;

    if(s == NULL){
	fputs("\\rule{0mm}{2ex}",fp);
	return;
    }

    if(nostack == Off)
	fputs("\\shortstack[l]{\\rule{0mm}{2ex}",fp);

    if(latex_command_flag == On){	/* LaTeX ̿ */
	fputs(s,fp);
    }else{				/* ʸ */
	for(p = s ; *p != '\0' ; p++){
	    switch(*p){
		case '\\':
		    fprintf(fp,"$\\backslash$");
		    break;
		case '|':
		case '<':
		case '>':
		case '*':
		case '-':
		    fprintf(fp,"$%c$",*p);
		    break;
		case '^':
		case '_':
		case '~':
		    fprintf(fp,"\\%c{}",*p);
		    break;
		case ':':
		case ',':
		    if(case_flag == On)
			fprintf(fp,"{%c}",*p);
		    else
			putc(*p,fp);
		    break;
		case '{':
		case '}':
		case '$':
		case '&':
		case '#':
		case '%':
		case ' ':
		    fprintf(fp,"\\%c",*p);
		    break;
		case '\t':
		    fprintf(fp,"\\ ");
		    break;
		default:
		    putc(*p,fp);
	    }
	}
    }

    if(nostack == Off)
	fputs("}",fp);
}

void print_tab(void)
/* Ƭζ */
{
    int i;
    for(i = 0 ; i < tab ; i++)
	putc(' ',fp);
}

void body(PAD *ptr)
/* У */
{
    tab = - tab_width;

    if(titlebox == On)
	padtitle = ptr->str;

    fputs("\\begin{figure}[h]\n",fp);
    if(figure_locate == Top){
	if(figure != EOF  ||  (ptr->str != NULL  &&  titlebox == Off)){
	    putc('\n',fp);
	    fprintf(fp,"\\caption{");
	    if(ptr->str != NULL  &&  titlebox == Off){
		nostack = On;
		print(ptr->str);
		nostack = Off;
	    }
	    fputs("}\n",fp);
	}
    }
    putc('\n',fp);

    if(centering == On){		/* ˽ */
	fputs("\\begin{center}\n",fp);
	putc('\n',fp);
    }

    if(padframe == On)			/* УĤϤ */
	fputs("\\fbox{%\n",fp);

    if(ptr->child != NULL)
	commands(ptr->child);

    if(padframe == On){
	fputs("%\n",fp);
	fprintf(fp,"}");
    }

    putc('\n',fp);

    if(centering == On){
	putc('\n',fp);
	fputs("\\end{center}\n",fp);
    }

    if(figure_locate == Bottom){
	if(figure != EOF  ||  (ptr->str != NULL  &&  titlebox == Off)){
	    putc('\n',fp);
	    fprintf(fp,"\\caption{");
	    if(ptr->str != NULL  &&  titlebox == Off){
		nostack = On;
		print(ptr->str);
		nostack = Off;
	    }
	    fputs("}\n",fp);
	}
    }
    putc('\n',fp);
    fputs("\\end{figure}\n",fp);
    putc('\n',fp);
}

void commands(PAD *ptr)
{
    PAD *p;
    int child = 0, count = 0;
    bool seq_flag = Off;

    for(p = ptr ; p != NULL ; p = p->next){
	if( ! is_controlcode(p->type))
	    child++;
    }
    if(child > 1  ||  (padtitle != NULL  &&  titlebox == On))
	seq_flag = On;

    tab += tab_width;

    if(seq_flag == On){
	print_tab();
	fputs("\\padseq{%\n",fp);
	tab += tab_width;
    }

    if(padtitle != NULL  &&  titlebox == On){	/* ƣУĤΥȥ */
	print_tab();
	fprintf(fp,"\\padsub{");
	print(padtitle);
	fprintf(fp,"}");
	padtitle = NULL;
	count++;
    }

    for(p = ptr ; p != NULL ; p = p->next){
	if( ! is_controlcode(p->type)){
	    count++;
	    if(count > 1)
		fputs(" \\\\ %\n",fp);
	    command(p);
	}
    }

    if(seq_flag == On){
	fputs("%\n",fp);
	tab -= tab_width;
	print_tab();
	fprintf(fp,"}");
    }

    tab -= tab_width;
}

void command(PAD *ptr)
{
    char *p;

    switch(ptr->type){
	case For:
	case While:
	case Do:
	    repeat_statement(ptr);
	    break;
	case If:
	case Switch:
	    branch_statement(ptr);
	    break;
	case Block:
	    block_statement(ptr);
	    break;
	case Message:
	    print_tab();
	    fprintf(fp,"\\padmessage{");
	    print(ptr->str);
	    fprintf(fp,"}");
	    break;
	case Label:
	    print_tab();
	    fprintf(fp,"\\padlabel{");
	    print(ptr->str);
	    fprintf(fp,"}");
	    if(ptr->child != NULL){	/*  */
		fprintf(fp," \\padcomment{");
		print(ptr->child->str);
		putc('}',fp);
	    }
	    break;
	case Refer:
	    refer_statement(ptr);
	    break;
	default:
	    print_tab();
	    fprintf(fp,"\\padbox{");
	    print(ptr->str);
	    fprintf(fp,"}");
	    if(ptr->child != NULL){	/*  */
		fprintf(fp," \\padcomment{");
		print(ptr->child->str);
		putc('}',fp);
	    }
    }
}

void block_statement(PAD *ptr)
/* ֥å */
{
    PAD *p;
    int count = 0;

    print_tab();
    fputs("\\padboxss{%\n",fp);

    tab += tab_width;

    print_tab();

    for(p = ptr->child ; p != NULL ; p = p->next){
	count++;
	if(count > 1){
	    fputs(" \\\\ \n",fp);
	    print_tab();
	}
	print(p->str);
    }
    fputs("%\n",fp);

    tab -= tab_width;

    print_tab();
    fprintf(fp,"}");

    if(ptr->depth != NULL){	/*  */
	fprintf(fp," \\padcomment{");
	print(ptr->depth->str);
	putc('}',fp);
    }
}

void refer_statement(PAD *ptr)
/*  */
{
    PAD *p;
    int count = 0;
    int ref = 0;

    for(p = ptr->child ; p != NULL ; p = p->next)
	ref++;
    ref = (ref + 1) / 2;

    print_tab();
    fputs("\\padboxss{%\n",fp);

    tab += tab_width;

    print_tab();

    for(p = ptr->child ; p != NULL ; p = p->next){
	count++;
	if(count > 1){
	    fputs(" \\\\ \n",fp);
	    print_tab();
	}
	print(p->str);
	if(count == ref){
	    fputs(" \\padref{",fp);
	    print(ptr->str);
	    fputs("}",fp);
	}
    }
    fputs("%\n",fp);

    tab -= tab_width;

    print_tab();
    fprintf(fp,"}");

    if(ptr->depth != NULL){	/*  */
	fprintf(fp," \\padcomment{");
	print(ptr->depth->str);
	putc('}',fp);
    }
}

void repeat_statement(PAD *ptr)
/* forʸwhileʸdo-whileʸ */
{
    switch(ptr->type){
	case For:
	case While:
	    print_tab();
	    fprintf(fp,"\\padwhile{");
	    break;
	case Do:
	    print_tab();
	    fprintf(fp,"\\padrepeat{");
	    break;
    }
    print(ptr->str);
    fputs("}{%\n",fp);

    commands(ptr->child);

    fputs("%\n",fp);

    print_tab();
    fprintf(fp,"}");
}

void branch_statement(PAD *ptr)
/* ifʸswitchʸ */
{
    PAD *p;
    int count = 0;

    for(p = ptr->child ; p != NULL ; p = p->next)
	count++;

    if(count == 1  ||  (count == 2  &&  ptr->child->next->str == NULL))
	if_statement(ptr);
    else
	switch_statement(ptr);
}

void if_statement(PAD *ptr)
/* ifʸ */
{
    PAD *p;

    p = ptr->child;

    print_tab();
    fprintf(fp,"\\padcond{");
    print(p->str);
    fputs("}{%\n",fp);
    commands(p->child);
    fputs("%\n",fp);
    print_tab();
    if(p->next == NULL)			/* if Τ */
	fprintf(fp,"}{}");
    else{				/* else  */
	fputs("}{%\n",fp);
	commands(p->next->child);
	fputs("%\n",fp);
	print_tab();
	fprintf(fp,"}");
    }
}

void switch_statement(PAD *ptr)
/* switchʸ */
{
    PAD *p,*q;
    int count = 0;

    print_tab();
    fputs("\\padcase{}{%\n",fp);

    tab += tab_width;

    for(p = ptr->child ; p != NULL ; p = p->next){
	count++;
	if(count > 1)
	    fputs(",%\n",fp);

	print_tab();

	if(p->depth == NULL){		/* ʬ٥뤬 */
	    case_flag = On;
	    print(p->str);
	    case_flag = Off;
	}else{
	    fputs("\\shortstack[l]{%\n",fp);
	    tab += tab_width;
	    for(q = p ; q != NULL ; q = q->depth){
		print_tab();
		print(q->str);
		if(q->depth != NULL)
		    fprintf(fp," \\\\ ");
		fputs("%\n",fp);
	    }
	    tab -= tab_width;
	    print_tab();
	    fprintf(fp,"}");
	}

	fputs(":%\n",fp);

	commands(p->child);
    }

    tab -= tab_width;

    fputs("%\n",fp);
    print_tab();
    fprintf(fp,"}");
}

int is_controlcode(TYPE t)
/* 楳ɤʤ鿿 */
{
    switch(t){
	case Empty:
	case Newpage:
	case Vsp:
	    return 1;
	default:
	    return 0;
    }
}
