/*                         */
/*  pad2ps.h               */
/*                         */
/*  pad2ps  by S. Yoshida  */
/*                         */

#ifndef _PAD2PS_H
#define _PAD2PS_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* ̵ϱѸǤ */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

#define SCALE		0.06	/* PostScriptΥ */
#define SQRT2		1.42	/* ٥롢ȤȾ¤η׻Ѥ */

#define X_MAX		9000	/* ѻαü */
#define Y_MAX		10000	/* ѻξü */
#define X_CENTER	4500	/* ѻ濴Σɸ */
#define PAGE_TOP	9800	/* ڡξü */
#define PAGE_BOTTOM	0	/* ڡβü */
#define PAGE_LEFT	500	/* ڡκü */
#define PAGE_RIGHT	8500	/* ڡαü */
#define PAGENUMBER_Y	-1000	/* ڡֹνϰ */
#define INVALID		-50000	/* ̵ʺɸ */
#define INFINITY	50000	/* ̵ */

#define VSPACE		120	/* ܥå֤νĤδֳ */
#define HSPACE		200	/* ܥå֤βδֳ */
#define BOX_VSPACE	25	/* ܥåνĤΥڡ */
#define IF_VSPACE	50	/* ifʸΥܥåνĤΥڡ */
#define BOX_HSPACE	125	/* ܥåζڡ */
#define IF_RIGHTSPACE	200	/* ifʸΥܥåα¦Υڡ */
#define SIDELINE_SPACE	50	/* forʸʤɤβδֳ */
#define PAD_VSPACE	400	/* УĴ֤νĤδֳ */
#define PADFRAME_VSPACE	180	/* УĤϤȤνĤΥڡ */
#define PADFRAME_HSPACE	300	/* УĤϤȤβΥڡ */

#define LINEWIDTH	16	/*  */
#define PADLINEWIDTH	16	/* УĤ */
#define FRAMELINEWIDTH	8	/* Ȥ */

#define FONTSIZE	200	/* եȥʸι⤵ */
#define FONTWIDTH	100	/* ѿʸβ */
#define JFONTWIDTH	200	/* ܸ죱ʸβ */
#define TITLE_RATE	2.0	/* ȥʸΨ */
#define PADTITLE_RATE	1.5	/* ƣУĤΥȥʸΨ */
#define FIGURE_RATE	1.5	/* ƣУĤοΨ */
#define CHAR_BASEUP	40	/* ʸ򾯤˾夲 */
#define JCHAR_BASEUP	20	/* ܸʸ򾯤˾夲 */


typedef struct _PAD PAD;
typedef struct _BOX BOX;
typedef struct _STRING STRING;
typedef struct _INT2 INT2;

typedef enum {
    Root, Title,
    Message, Comment,
    Newpage, Vsp,
    Empty, Str, Box, Figure,
    Padtitle, For, While, Do,
    Block, If, Switch, Cond,
    Label, Refer,
    Line, Padframe,
    Topdown, Middle, Bottomup,
    Top, Bottom
} TYPE;

struct _PAD {
    TYPE type;
    char *str;
    int value;
    int lines;
    int space_width;
    int whole_width;
    int child_number;
    int depth_number;
    int amount;
    bool enable_fold;
    PAD *child;
    PAD *depth;
    PAD *next;
};

struct _BOX {
    TYPE type;
    STRING *str;
    int x;
    int y;
    int w;
    int h;
    bool flag1;
    bool flag2;
    BOX *prev;
    BOX *next;
};

struct _STRING {
    char *str;
    int x;
    int y;
#ifdef JAPANESE
    bool jflag;
#endif
    STRING *next;
};

struct _INT2 {
    int count;
    int amount;
};


extern bool quiet;		/* -quiet ץ */
#ifdef DEBUG
extern bool debug;		/* -debug ץ */
#endif

extern bool eps_flag;		/* pad2eps  */
extern bool latex_command_flag;	/* ʸ LaTeX ̿Ȥư */

extern char *title;		/* 祿ȥ */
extern bool titlebox;		/* ƣУĤΥȥܥå褹뤫 */
extern bool page_print;		/* ڡֹϤ뤫 */
extern int page;		/* ϥڡݣ */
extern int figure;		/* ֹ */
extern TYPE figure_locate;	/* ΰ */
extern bool figure_locate_flag;	/* figure_locate ꤷ */
extern bool centering;		/* ˽Ϥ뤫 */
extern bool poster;		/* ݥ */
extern bool slice;		/* ƣУĤڡƬ */

extern int tab_width;		/*  */

extern TYPE locate_type;	/* УĤַ */

extern bool pageframe;		/* ƥڡȤɽ뤫 */
extern bool padframe;		/* ƣУĤȤɽ뤫 */

extern int page_top;		/* ڡξü */
extern int page_bottom;		/* ڡβü */
extern int page_left;		/* ڡκü */
extern int page_right;		/* ڡαü */
extern int page_width;		/* ڡ */
extern int x_center;		/* ڡcenteringOnλ 0 */
extern int right_limit;		/* θ³ */
extern int left_limit;		/* θ³ */

extern int max_length;		/* УĤʸκĹ */
extern int min_length;		/* УĤʸκǾĹ */

extern int vspace;		/* ܥå֤νĤδֳ */
extern int hspace;		/* ܥå֤βδֳ */
extern int box_vspace;		/* ܥåνĤΥڡ */
extern int if_vspace;		/* ifܥåνĤΥڡ */
extern int box_hspace;		/* ܥåζڡ */
extern int if_rightspace;	/* ifܥåα¦Υڡ */
extern int sideline_space;	/* forʸʤɤβδֳ */
extern int box_height;		/* ܥåι⤵ */
extern int if_height;		/* ifܥåι⤵ */
extern int pad_vspace;		/* УĴ֤νĤδֳ */
extern int padframe_vspace;	/* УĤϤȤνĤΥڡ */
extern int padframe_hspace;	/* УĤϤȤβΥڡ */

extern int linewidth;		/*  */
extern int padlinewidth;	/* УĤ */
extern int framelinewidth;	/* Ȥ */

extern int fontsize;		/* եȥ */
extern int fontwidth;		/* ѿʸβ */
extern int jfontwidth;		/* ܸ죱ʸβ */
extern double title_rate;	/* ȥʸΨ */
extern double padtitle_rate;	/* ƣУĤΥȥʸΨ */
extern double figure_rate;	/* ƣУĤοΨ */

extern char font[];		/* ե */
extern char title_font[];	/* ȥΥե */
#ifdef JAPANESE
extern char jfont[];		/* ܸե */
extern char title_jfont[];	/* ȥܸե */
#endif

extern double vrate;		/* ĤγΨ */
extern double hrate;		/* γΨ */

extern double proper_hrate;	/* Ŭhrate */

extern int first_x;		/* ΤγΣ */
extern int next_y;		/* ΣУĤΣɸ */

extern int most_right;		/* ΤκǤⱦΣ */
extern int most_left;		/* ΤκǤ⺸Σ */

extern PAD *root;		/* ڹ¤κ */
extern PAD *current;		/* ڹ¤θ߰ */
extern BOX *first;		/* ꥹȤκǽ */
extern BOX *lp;			/* ꥹȤθ߰ */

extern bool print_warning;	/* warningϤ뤫 */
extern int line_count;		/* Ƥ */

extern FILE *input_stream;	/* ϥե */
extern FILE *fp;		/* ϥե */
extern char outfile[];		/* ϥե̾ */
extern char outdir[];		/* ϥեǥ쥯ȥ */


/* fold.c */
extern void fold(void);			/* УĤμưޤʤ */
extern void refold_pad(PAD *,int);	/* ޤʤκƷ׻ */
extern int is_box(PAD *);		/* Уĥܥåˤʤ뤫 */

/* font.c */
extern void change_font(double);	/* եȤѹ */
extern void restore_font(void);		/* եȤ᤹ */

/* locate.c */
extern void locate(void);	/* УĤ */

/* parser.l */
extern void parser(void);	/* ϡʸ */

/* ps.c */
extern void ps(void);		/* PostScript κ */

/* sort.c */
extern void sort(void);		/* BOXǡΥ */

/* string.c */
extern STRING *string(char *,int,int,int);	/* STRINGǡ */
extern int get_str_ww(char *);			/* ʸ֤ */
extern int get_str_width(PAD *);		/* ޤʤȤ֤ */
extern int get_str_height(PAD *);		/* ޤʤȤι⤵֤ */
extern int get_str_lines(PAD *,int);		/* ޤʤȤιԿ֤ */

/* tex.c */
extern void tex(void);		/* LaTeX ɤκ */

#endif  /* ! _PAD2PS_H */
