/*                              */
/*  pad2ps.c -- ᥤ롼  */
/*                              */
/*  pad2ps  by S. Yoshida       */
/*                              */

#include "config.h"

#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include "pad2ps.h"

bool quiet = Off;		/* -quiet ץ */
#ifdef DEBUG
bool debug = Off;		/* -debug ץ */
#endif

bool eps_flag = Off;		/* pad2eps  */
bool latex_command_flag = Off;	/* ʸ LaTeX ̿Ȥư */

char *title = NULL;		/* 祿ȥ */
bool titlebox = Off;		/* ƣУĤΥȥܥå褹뤫 */
bool page_print = Off;		/* ڡֹϤ뤫 */
int page = 0;			/* ϥڡݣ */
int figure = EOF;		/* ֹ */
TYPE figure_locate = Top;	/* ΰ */
bool figure_locate_flag = Off;	/* figure_locate ꤷ */
bool centering = On;		/* ˽Ϥ뤫 */
bool poster = Off;		/* ݥ */
bool slice = Off;		/* ƣУĤڡƬ */

int tab_width = 4;		/*  */

TYPE locate_type = Middle;	/* УĤַ */

bool pageframe = Off;		/* ƥڡȤɽ뤫 */
bool padframe = On;		/* ƣУĤȤɽ뤫 */

int page_top = PAGE_TOP;		/* ڡξü */
int page_bottom = PAGE_BOTTOM;		/* ڡβü */
int page_left = PAGE_LEFT;		/* ڡκü */
int page_right = PAGE_RIGHT;		/* ڡαü */
int page_width = PAGE_RIGHT-PAGE_LEFT;	/* ڡ */
int x_center = 0;		/* ڡcenteringOnλ 0 */
int right_limit = PAGE_RIGHT;		/* θ³ */
int left_limit = PAGE_LEFT;		/* θ³ */

int max_length = INFINITY;		/* УĤʸκĹ */
int min_length = 0;			/* УĤʸκǾĹ */

int vspace = VSPACE;			/* ܥå֤νĤδֳ */
int hspace = HSPACE;			/* ܥå֤βδֳ */
int box_vspace = BOX_VSPACE;		/* ܥåνĤΥڡ */
int if_vspace = IF_VSPACE;		/* ifܥåνĤΥڡ */
int box_hspace = BOX_HSPACE;		/* ܥåζڡ */
int if_rightspace = IF_RIGHTSPACE;	/* ifܥåα¦Υڡ */
int sideline_space = SIDELINE_SPACE;	/* forʸʤɤβδֳ */
int box_height = BOX_VSPACE*2+FONTSIZE;	/* ܥåι⤵ */
int if_height = IF_VSPACE*2+FONTSIZE;	/* ifܥåι⤵ */
int pad_vspace = PAD_VSPACE;		/* УĴ֤νĤδֳ */
int padframe_vspace = PADFRAME_VSPACE;	/* УĤϤȤνĤΥڡ */
int padframe_hspace = PADFRAME_HSPACE;	/* УĤϤȤβΥڡ */

int linewidth = LINEWIDTH;		/*  */
int padlinewidth = PADLINEWIDTH;	/* УĤ */
int framelinewidth = FRAMELINEWIDTH;	/* Ȥ */

int fontsize = FONTSIZE;		/* եȥʸι⤵ */
int fontwidth = FONTWIDTH;		/* ѿʸβ */
int jfontwidth = JFONTWIDTH;		/* ܸ죱ʸβ */
double title_rate = TITLE_RATE;		/* ȥʸΨ */
double padtitle_rate = PADTITLE_RATE;	/* ƣУĤΥȥʸΨ */
double figure_rate = FIGURE_RATE;	/* ƣУĤοΨ */

char font[] = "Courier";			/* ե */
char title_font[] = "Courier-Bold";		/* ȥΥե */
#ifdef JAPANESE
char jfont[] = "Ryumin-Light-EUC-H";		/* ܸե */
char title_jfont[] = "GothicBBB-Medium-EUC-H";	/* ȥܸե */
#endif

double vrate = 1.0;		/* ĤγΨ */
double hrate = 1.0;		/* γΨ */

double proper_hrate = 99999.9;	/* Ŭhrate */

int first_x = 0;		/* ΤγΣ */
int next_y = 10;		/* ΣУĤΣɸ */

int most_right = 0;		/* ΤκǤⱦΣ */
int most_left = PAGE_RIGHT;	/* ΤκǤ⺸Σ */

PAD *root = NULL;		/* ڹ¤κ */
PAD *current = NULL;		/* ڹ¤θ߰ */
BOX *first = NULL;		/* ꥹȤκǽ */
BOX *lp = NULL;			/* ꥹȤθ߰ */

bool print_warning = Off;	/* warningϤ뤫 */
int line_count = 1;		/* Ƥ */

FILE *input_stream;		/* ϥե */
FILE *fp = stdout;		/* ϥե */
char outfile[BUFSIZ] = {'\0'};	/* ϥե̾ */
char outdir[BUFSIZ] = {'\0'};	/* ϥեǥ쥯ȥ */


#ifdef JAPANESE
static char kconv[BUFSIZ] = "nkf -e";	/* С */
static bool noconv = Off;		/* -noconv */
#endif
static bool nohelp = Off;		/* -nohelp */
static bool parameter_flag = Off;	/* -P */
static bool stdin_flag = Off;		/* -stdin */

static char thiscmd[BUFSIZ] = {'\0'};	/* ưޥ̾ */
static char filename[BUFSIZ] = {'\0'};	/* ϥե̾ */
static char command[BUFSIZ];		/* ޥ */
static char paramfile[BUFSIZ];		/* ѥ᡼ѥե̾ */


static void pad_parser(void);		/* PAD Υѡ򥳡 */
static void parameter(void);		/* -P ǻꤷѥ᡼ */

static void option(int,char **);	/* ץν */
static void print_help(void);		/* إץå */

#if defined(HAVE_ATEXIT)
static void at_exit(void);		/* λν */
#elif defined(HAVE_ON_EXIT)
static void at_exit(int,void *);	/* λν */
#endif

int main(int argc,char **argv)
{
    char *env;

    /* exit() κݤν */
#if defined(HAVE_ATEXIT)
    atexit(at_exit);
#elif defined(HAVE_ON_EXIT)
    on_exit(at_exit,NULL);
#endif

    /* ѥ᡼ѥե̾ */
#ifdef TMP
    strcpy(paramfile,TMP);
    strcat(paramfile,"/");
#else
    strcpy(paramfile,"/tmp/");
#endif
    if((env = getenv("TMP")) != NULL  &&  strlen(env) > 0){
	/* Ķѿ TMP  */
	strcpy(paramfile,env);
	strcat(paramfile,"/");
    }
    strcat(paramfile,"pad2ps-XXXXXX");

    option(argc,argv);			/* ץν */

    if(quiet == Off)
	fprintf(stderr,"\n%s %s  by %s\n\n",thiscmd,VERSION,AUTHOR);

    pad_parser();			/* PAD Υѡ򥳡 */
    parameter();			/* -P ǻꤷѥ᡼ */

    if(outfile[0] != '\0'  &&  outdir[0] != '\0'){	/* ϥեΥǥ쥯ȥ */
	char tmp[BUFSIZ];
	strcpy(tmp,outfile);
	sprintf(outfile,"%s/%s",outdir,tmp);
    }

    if(strcmp(thiscmd,"pad2tex") == 0)
	tex();
    else{
	fold();
	locate();
	sort();
	if(strcmp(thiscmd,"pad2eps") == 0)
	    eps_flag = On;
	ps();
    }

    if(quiet == Off)
	fprintf(stderr,"\n%d errors, %d warnings.\n",error_count,warning_count);

    return 0;
}

void pad_parser(void)
/* PAD Υѡ򥳡 */
{
    if(stdin_flag == On)
	filename[0] = '\0';

#ifdef JAPANESE
    if(noconv == Off)
	sprintf(command,"cat %s | %s",filename,kconv);
    else
#endif
	sprintf(command,"cat %s",filename);

    input_stream = popen(command,"r");

    parser();

    pclose(input_stream);
}

void parameter(void)
/* -P ǻꤷѥ᡼ */
{
    char tmp[BUFSIZ];

    if(parameter_flag == On){
#ifdef JAPANESE
	if(noconv == Off)
	    sprintf(command,"cat %s | %s",paramfile,kconv);
	else
#endif
	    sprintf(command,"cat %s",paramfile);

	input_stream = popen(command,"r");
	parser();
	pclose(input_stream);

	remove(paramfile);
    }
}

void option(int argc,char **argv)
/* ץν */
{
    int i,l,p = -1;

    for(i = 0 ; argv[0][i] != '\0' ; i++){	/* ưޥ̾μ */
	if(argv[0][i] == '/')
	    p = i;
    }
    strcpy(thiscmd,&argv[0][p+1]);

    for(i = 1 ; i < argc ; i++){
	if(argv[i][0] != '-'){
	    if(filename[0] == '\0'){		/* ϥե̾ */
		strcpy(filename,argv[i]);
		l = strlen(argv[i]);
		title = (char *)malloc((l+2) * sizeof(char));
		strcpy(title,argv[i]);
	    }else if(outfile[0] == '\0')	/* ϥե̾ */
		strcpy(outfile,argv[i]);
	    else if(nohelp == Off){
		print_help();
		exit(1);
	    }
	}else{				/* ץ */
	    switch(argv[i][1]){
		case 'd':
		    if(strcmp(argv[i],"-dir") == 0){
			strcpy(outdir,argv[++i]);
#ifdef DEBUG
		    }else if(strcmp(argv[i],"-debug") == 0){
			debug = On;
#endif
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'h':
		    if(strcmp(argv[i],"-help") == 0){
			print_help();
			exit(0);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#ifdef JAPANESE
		case 'k':
		    if(strcmp(argv[i],"-kconv") == 0  &&  i + 1 < argc){
			strcpy(kconv,argv[++i]);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#endif
		case 'n':
		    if(strcmp(argv[i],"-nohelp") == 0){
			nohelp = On;
#ifdef JAPANESE
		    }else if(strcmp(argv[i],"-noconv") == 0){
			noconv = On;
#endif
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'P':
		    if(strcmp(argv[i],"-P") == 0){
			FILE *fp;

			parameter_flag = On;
			mktemp(paramfile);
			fp = fopen(paramfile,"w");
			i++;
			while(i < argc  &&  argv[i][0] != '-'){
			    fprintf(fp,"/* pad2ps: %s */\n",argv[i]);
			    i++;
			}
			i--;
			fclose(fp);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'q':
		    if(strcmp(argv[i],"-quiet") == 0){
			quiet = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 's':
		    if(strcmp(argv[i],"-stdin") == 0){
			stdin_flag = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 't':
		    if(strcmp(argv[i],"-tab") == 0){
			i++;
			tab_width = atoi(argv[i]);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'w':
		    if(strcmp(argv[i],"-warn") == 0){
			print_warning = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		default:
		    if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
	    }
	}
    }
}

void print_help(void)
{
    fprintf(stderr,"\n%s %s  by %s\n\n",thiscmd,VERSION,AUTHOR);
    fprintf(stderr,"usage: %s [inputfile [outputfile]] [options]\n",thiscmd);
#ifdef DEBUG
    fputs("-debug                  Print parser debug message.\n",stderr);
#endif
    fputs("-dir directory          Directory to output files.\n",stderr);
    fputs("-help                   Print help message.\n",stderr);
#ifdef JAPANESE
    fputs("-kconv converter        Kanji code converter [default: \"nkf -e\"].\n",stderr);
    fputs("-noconv                 Do not convert kanji code.\n",stderr);
#endif
    fputs("-nohelp                 Do not print help message.\n",stderr);
    fputs("-P parameters ...       Set parameters. Ex: -P page=1 figure=1\n",stderr);
    fputs("-quiet                  Do not print messages.\n",stderr);
    fputs("-stdin                  Input from stdin.\n",stderr);
    fputs("-tab width              Set TAB width [default: 4].\n",stderr);
    fputs("-warn                   Print warnings.\n",stderr);
}


#if defined(HAVE_ATEXIT) || defined(HAVE_ON_EXIT)
#if defined(HAVE_ATEXIT)
void at_exit(void)
#elif defined(HAVE_ON_EXIT)
void at_exit(int val, void *p)
#endif
/* λν */
{
    remove(paramfile);
}
#endif
