/*                            */
/*  locate.c -- УĤ  */
/*                            */
/*  pad2ps  by S. Yoshida     */
/*                            */

#include "config.h"

#include <string.h>
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#include "pad2ps.h"
#include "lib.h"

static int page_number = 0;
static int padtitle_center = EOF;

static void init_locate(void);
static void init_body(void);

static void body(PAD *);
static int commands(PAD *,int);
static int command(PAD *,int);
static int message(PAD *,int);
static int just_string(PAD *p,int);
static int label_statement(PAD *p,int);
static int block_statement(PAD *p,int);
static int refer_statement(PAD *p,int);
static int repeat_statement(PAD *p,int);
static int branch_statement(PAD *p,int);
static int if_statement(PAD *p,int);
static int switch_statement(PAD *p,int);

static void print_title(void);
static void print_padtitle(PAD *);
static void print_figure(char *);
static void print_padframe(int);

static void print_pagenumber(void);
static void centerize(BOX *);
static void check_overflow(int,int);
static double calc_hrate(void);
static void move_down(BOX *,int);
static void move_right(BOX *,int);

static void pad_allocate(PAD *,int,int);
static void allocate(char *,int,int,int,int,TYPE);

void locate(void)
/* УĤ */
{
    PAD *ptr;
    int body_count = 0;
    int h,page_height;

#ifdef DEBUG
    if(quiet == Off)
        fprintf(stderr,"PAD locating starts...");
#endif

    init_locate();

    if(title != NULL)
	print_title();

    for(ptr = root->next ; ptr != NULL ; ptr = ptr->next){
	init_body();

	switch(ptr->type){
	    case Empty:
		if(body_count > 0)
		    next_y += pad_vspace;
		break;
	    case Newpage:
		page_height = (int)((page_top - page_bottom) / vrate);
		h = (next_y - vspace) % page_height;
		next_y += page_height - h + 1;
		break;
	    case Vsp:
		next_y += ptr->value;
		break;
	    default:
		if (body_count > 0  &&  slice == On) {
		    page_height = (int)((page_top - page_bottom) / vrate);
		    h = (next_y - vspace) % page_height;
		    next_y += page_height - h + 1;
		}
		body(ptr);
		body_count++;
	}
    }

    next_y -= pad_vspace;

    if(quiet == Off  &&  print_warning == On){	/* ڡֹ */
        if(next_y / (int)((double)(page_top - page_bottom) / vrate) > page_number)
	    print_pagenumber();
        print_pagenumber();
    }

#ifdef DEBUG
    if(quiet == Off)
        fprintf(stderr,"done\n");
#endif
}

void init_locate(void)
/*  */
{
    first_x = 0;
    next_y = 10;
    page_number = 0;
    first = NULL;
    lp = NULL;

    if(figure_locate_flag == Off){	/* figure_locate Υǥե */
	if(figure == EOF)
	    figure_locate = Top;
	else
	    figure_locate = Bottom;
    }
}

void init_body(void)
/* УΤȤν */
{
    most_right = 0;
    most_left = PAGE_RIGHT;
}

void body(PAD *ptr)
/* У */
{
    BOX *p;
    int frame_y;

    p = lp;

    if(titlebox == On){
	if(figure_locate == Top  &&  figure != EOF)
	    print_figure(NULL);
	if(padframe == On){
	    frame_y = next_y;
	    next_y += padframe_vspace;
	}
	if(ptr->str != NULL){
	    pad_allocate(ptr,first_x,next_y);
	    padtitle_center = next_y + lp->h / 2;
	    next_y += lp->h + vspace;
	}
    }else{
	if(figure_locate == Top){
	    if(figure == EOF){
		if(ptr->str != NULL)
		    print_padtitle(ptr);
	    }else
		print_figure(ptr->str);

	    p = lp;
	}
	if(padframe == On){
	    frame_y = next_y;
	    next_y += padframe_vspace;
	}
    }

    if(ptr->child != NULL)
	commands(ptr->child,first_x);

    if(padframe == On)		/* УĤȤɽ */
        print_padframe(frame_y);

    if(centering == On)		/* ˽ */
        centerize(p);

    proper_hrate = smaller(proper_hrate,calc_hrate());

    if(figure_locate == Bottom){
	if(figure == EOF){
	    if(ptr->str != NULL  &&  titlebox == Off)
		print_padtitle(ptr);
	}else
	    print_figure(ptr->str);
    }
}

int commands(PAD *ptr,int x)
/* ǽΣУĥܥå濴Σɸ֤ */
{
    PAD *p;
    int first_center = EOF;
    int last_center,center;
    int first_mes = EOF,last_mes;
    int h,page_height;

    for(p = ptr ; p != NULL ; p = p->next){
	switch(p->type){
	    case Newpage:
		page_height = (int)((page_top - page_bottom) / vrate);
		h = (next_y - vspace) % page_height;
		next_y += page_height - h + 1;
		break;
	    case Empty:
		next_y += vspace;
		break;
	    case Vsp:
		next_y += p->value;
		break;
	    case Message:
	    case Label:
		last_mes = command(p,x);
		if(first_mes == EOF)
		    first_mes = last_mes;
		break;
	    default:
		center = command(p,x);
		if(center != EOF){
		    if(first_center == EOF){
			first_center = center;
			if(padtitle_center != EOF  &&  x == first_x){
						/* УĤΥȥȷ */
			    allocate(NULL,x,padtitle_center,0,center - padtitle_center,Line);
			    padtitle_center = EOF;
			}
		    }else
			allocate(NULL,x,last_center,0,center - last_center,Line);
						/*  */
		    last_center = center;
		}
	}
    }

    if(first_center != EOF){	/* դĤξ */
	switch(locate_type){
	    case Topdown:
		return first_center;
	    case Middle:
		return (first_center + last_center) / 2;
	    case Bottomup:
		return last_center;
	}
    }else{
	if(first_mes != EOF){	/* åΤߤξ */
	    switch(locate_type){
		case Topdown:
		    return first_mes;
		case Middle:
		    return (first_mes + last_mes) / 2;
		case Bottomup:
		    return last_mes;
	    }
	}else			/* ʤԤΤߤξ */
	    return EOF;
    }
}

int command(PAD *ptr,int x)
/* 濴Σɸ֤ */
{
    int center;

    if(quiet == Off  &&  print_warning == On  && 
       (next_y - vspace) / (int)((double)(page_top - page_bottom) / vrate) > page_number)
        print_pagenumber();		/* ڡֹ */

    switch(ptr->type){
	case For:
	case While:
	case Do:
	    center = repeat_statement(ptr,x);
	    break;
	case If:
	case Switch:
	    center = branch_statement(ptr,x);
	    break;
	case Block:
	    center = block_statement(ptr,x);
	    break;
	case Label:
	    center = label_statement(ptr,x);
	    break;
	case Refer:
	    center = refer_statement(ptr,x);
	    break;
	case Message:
	    center = message(ptr,x);
	    break;
	default:
	    center = just_string(ptr,x);
	    break;
    }

    return center;
}

int message(PAD *ptr,int x)
/* å */
{
    int center;
    refold_pad(ptr,right_limit - x - box_hspace);
    allocate(ptr->str,x + box_hspace,next_y,get_str_width(ptr),get_str_height(ptr),Str);
    center = next_y + lp->h / 2;
    next_y += lp->h + vspace;
    return center;
}

int just_string(PAD *ptr,int x)
/* ΣУĥܥå */
{
    PAD *p;
    BOX *rt;
    int center;
    int h,w;

    p = ptr->child;

    if(p == NULL){			/* Ȥʤ */
	refold_pad(ptr,right_limit - x - box_hspace * 2);
	pad_allocate(ptr,x,next_y);
	center = next_y + lp->h / 2;
	next_y += lp->h + vspace;
    }else{				/* Ȥ */
	pad_allocate(ptr,x,next_y);
	center = next_y + lp->h / 2;
	h = lp->h;
	w = lp->w + box_hspace;
	rt = lp;

	refold_pad(p,right_limit - x - w);
	allocate(p->str,x + w,next_y,get_str_width(p),get_str_height(p),Str);

	if(h > lp->h){			/* Ȥ򲼤˰ư */
	    move_down(lp,(h - lp->h) / 2);
	    next_y += h + vspace;
	}else{				/* ܥå򲼤˰ư */
	    move_down(rt,(lp->h - h) / 2);
	    center += (lp->h - h) / 2;
	    next_y += lp->h + vspace;
	}
    }

    return center;
}

int label_statement(PAD *ptr,int x)
/* ٥ */
{
    PAD *p;
    BOX *rt;
    int center;
    int h,w;

    p = ptr->child;

    if(p == NULL){			/* Ȥʤ */
	refold_pad(ptr,(int)((double)(right_limit - x - linewidth) / SQRT2));
	pad_allocate(ptr,x,next_y);
	center = next_y + lp->h / 2;
	next_y += lp->h + vspace;
    }else{				/* Ȥ */
	pad_allocate(ptr,x,next_y);
	center = next_y + lp->h / 2;
	h = lp->h;
	w = lp->w + box_hspace;
	rt = lp;

	refold_pad(p,right_limit - x - w);
	allocate(p->str,x + w,next_y,get_str_width(p),get_str_height(p),Str);

	if(h > lp->h){			/* Ȥ򲼤˰ư */
	    move_down(lp,(h - lp->h) / 2);
	    next_y += h + vspace;
	}else{				/* ܥå򲼤˰ư */
	    move_down(rt,(lp->h - h) / 2);
	    center += (lp->h - h) / 2;
	    next_y += lp->h + vspace;
	}
    }

    return center;
}

int block_statement(PAD *ptr,int x)
/* ֥å */
{
    PAD *p;
    BOX *rt,*bp;
    int center,dy,h,w = 0;

    for(p = ptr->child ; p != NULL ; p = p->next){
	if(p->type != Empty){
	    if(ptr->depth == NULL)		/* Ȥʤʤ */
		refold_pad(p,right_limit - x - box_hspace * 2);
	    w = greater(w,get_str_width(p));
	}
    }

    rt = lp;

    dy = box_vspace;
    for(p = ptr->child ; p != NULL ; p = p->next){
	if(p->type == Empty){
	    dy += vspace;
	}else{
	    allocate(p->str,x + box_hspace,next_y + dy,w,0,Str);
	    p->lines = get_str_lines(p,w);
	    lp->h = get_str_height(p);
	    dy += lp->h;
	}
    }
    dy += box_vspace;

    w = lp->w + box_hspace * 2;
    allocate(NULL,x,next_y,w,dy,Box);
    center = next_y + lp->h / 2;
    h = lp->h;
    w = lp->w + box_hspace;

    p = ptr->depth;

    if(p != NULL){		/* Ȥ */
	refold_pad(p,right_limit - x - w);
	allocate(p->str,x + w,next_y,get_str_width(p),get_str_height(p),Str);

	if(h > lp->h){			/* Ȥ򲼤˰ư */
	    move_down(lp,(h - lp->h) / 2);
	    next_y += h + vspace;
	}else{				/* ֥å򲼤˰ư */
	    for(bp = rt ; bp != lp ; bp = bp->next)
		move_down(bp,(lp->h - h) / 2);
	    center += (lp->h - h) / 2;
	    next_y += lp->h + vspace;
	}
    }else			/* Ȥʤ */
	next_y += h + vspace;

    return center;
}

int refer_statement(PAD *ptr,int x)
/*  */
{
    PAD *p;
    BOX *rt,*bp;
    int center,dy,h,w = 0,rx;

    for(p = ptr->child ; p != NULL ; p = p->next){
	if(p->type != Empty){
	    if(ptr->depth == NULL)		/* Ȥʤʤ */
		refold_pad(p,right_limit - x - (int)((double)get_str_width(ptr) * SQRT2) - box_hspace * 3);
	    w = greater(w,get_str_width(p));
	}
    }

    rt = lp;

    dy = box_vspace;
    for(p = ptr->child ; p != NULL ; p = p->next){
	if(p->type == Empty){
	    dy += vspace;
	}else{
	    allocate(p->str,x + box_hspace,next_y + dy,w,0,Str);
	    p->lines = get_str_lines(p,w);
	    lp->h = get_str_height(p);
	    dy += lp->h;
	}
    }
    dy += box_vspace;

    rx = x + box_hspace * 2 + lp->w;
    w = lp->w + (int)((double)get_str_width(ptr) * SQRT2) + box_hspace * 3;
    allocate(NULL,x,next_y,w,dy,Box);
    center = next_y + lp->h / 2;
    h = lp->h;
    w = lp->w + box_hspace;

    pad_allocate(ptr,rx,next_y + box_vspace);

    if(h > lp->h + box_vspace * 2){	/* Ȥ򲼤˰ư */
	move_down(lp,(h - lp->h - box_vspace * 2) / 2);
    }else{				/* ֥å򲼤˰ư */
	for(bp = rt ; bp->next != lp ; bp = bp->next)
	    move_down(bp,(lp->h + box_vspace * 2 - h) / 2);
	bp->h = lp->h + box_vspace * 2;
	center += (lp->h + box_vspace * 2 - h) / 2;
	h = lp->h + box_vspace * 2;
    }

    p = ptr->depth;

    if(p != NULL){		/* Ȥ */
	refold_pad(p,right_limit - x - w);
	allocate(p->str,x + w,next_y,get_str_width(p),get_str_height(p),Str);

	if(h > lp->h){			/* Ȥ򲼤˰ư */
	    move_down(lp,(h - lp->h) / 2);
	    next_y += h + vspace;
	}else{				/* ֥å򲼤˰ư */
	    for(bp = rt ; bp != lp ; bp = bp->next)
		move_down(bp,(lp->h - h) / 2);
	    center += (lp->h - h) / 2;
	    next_y += lp->h + vspace;
	}
    }else			/* Ȥʤ */
	next_y += h + vspace;

    return center;
}

int repeat_statement(PAD *ptr,int x)
/* forʸwhileʸdo-whileʸ */
{
    BOX *rt,*p;
    int w,y,center,parent_next_y,child_y;
    bool none = Off;

    pad_allocate(ptr,x,next_y);
    center = next_y + lp->h / 2;
    parent_next_y = next_y + lp->h + vspace;

    rt = lp;
    w = lp->w;

    y = next_y;
    child_y = commands(ptr->child,x + w + hspace);
    if(child_y == EOF){		/* ȿʤԤΤߤξ */
	child_y = (y + next_y - vspace) / 2;
	none = On;
    }

    if(center < child_y){	/* for,while,do-whileʸ򲼤˰ư */
	move_down(rt,child_y - center);
	center += child_y - center;
	parent_next_y += child_y - center;
    }else{			/* ȿΣУĤ򲼤˰ư */
	for(p = rt->next ; p != NULL ; p = p->next)
	    move_down(p,center - child_y);
	next_y += center - child_y;
    }

    if(none == Off)
	allocate(NULL,x + w,center,hspace,0,Line);	/*  */

    next_y = greater(next_y,parent_next_y);
    return center;
}

int branch_statement(PAD *ptr,int x)
/* ifʸswitchʸ */
{
    if(ptr->type == If  &&  (ptr->child_number == 1  ||
       (ptr->child_number == 2  &&  ptr->child->next->str == NULL)))
	return if_statement(ptr,x);
    else
	return switch_statement(ptr,x);
}

int if_statement(PAD *ptr,int x)
/* ifʸ */
{
    PAD *p;
    BOX *rt;
    int w,y,top,bottom,child_y;
    bool none1 = Off, none2 = Off;

    p = ptr->child;

    w = get_str_width(p) + p->space_width;

    y = next_y;
    top = commands(p->child,x + w + hspace);			/*  */
    if(top == EOF){		/* ʤԤΤߤξ */
	top = (y + next_y - vspace) / 2;
	none1 = On;
    }

    pad_allocate(p,x + box_hspace,top + if_vspace);
    rt = lp;
    bottom = top + if_vspace * 2 + lp->h;

    if(p->next != NULL){
	y = next_y;
	child_y = commands(p->next->child,x + w + hspace);	/*  */
	if(child_y == EOF){		/* ʤԤΤߤξ */
	    child_y = (y + next_y - vspace) / 2;
	    none2 = On;
	}

	if(bottom < child_y){			/* Ｐ򲼤˰ư */
	    move_down(rt,(child_y - bottom) / 2);
	    bottom = child_y;
	}else{					/* ʬ򲼤˰ư */
	    for(rt = rt->next ; rt != NULL ; rt = rt->next)
		move_down(rt,bottom - child_y);
	    next_y += bottom - child_y;
	}
	if(none2 == Off)
	    allocate(NULL,x + w,bottom,hspace,0,Line);	/*  */
    }

    if(none1 == Off)
	allocate(NULL,x + w,top,hspace,0,Line);		/*  */
    allocate(NULL,x,top,w,bottom - top,If);
    lp->flag1 = On; lp->flag2 = On;

    next_y = greater(next_y,bottom + vspace);
    return (top + bottom) / 2;
}

int switch_statement(PAD *ptr,int x)
/* switchʸ */
{
    PAD *p,*q;
    BOX *rt_labels,*rt;
    int i,y,h,w = 0;
    int cond_width;
    int top,bottom,center;
    int parent_next_y,child_y,prev_y,label_y;
    int count = 0;
    bool none = Off;

    if(ptr->child == NULL)	/* ȤΤʤ switchʸ */
	return EOF;

    parent_next_y = next_y;
    top = next_y;

    for(p = ptr->child ; p != NULL ; p = p->next)	/* ＰĹ */
	w = greater(w,get_str_width(p));
    cond_width = w;
    w += ptr->child->space_width;

    for(p = ptr->child ; p != NULL ; p = p->next){
	count++;

	rt_labels = lp;

	center = parent_next_y;
	for(q = p ; q != NULL ; q = q->depth){		/* ʬ٥ */
	    allocate(q->str,x + box_hspace,parent_next_y,cond_width,0,Str);
	    q->lines = get_str_lines(q,cond_width);
	    lp->h = get_str_height(q);
	    parent_next_y += lp->h;
	}
	center = (center + parent_next_y) / 2;
	parent_next_y += vspace;

	rt = lp;

	y = next_y;
	none = Off;
	child_y = commands(p->child,x + w + hspace);
	if(child_y == EOF){	/* ʬʤԤΤߤξ */
	    child_y = (y + next_y - vspace) / 2;
	    none = On;
	}

	if(count == 1){				/* ǽξＰ */
	    for(i = 0 ; i <= p->depth_number ; i++){
		rt_labels = rt_labels->next;
		move_down(rt_labels,child_y - top);
	    }
	    parent_next_y += child_y - top;
	    top = child_y;
	}else{
	    if(count == ptr->child_number)	/* ǸξＰ */
		label_y = parent_next_y - vspace;
	    else				/* ξＰ */
		label_y = center;

	    if(label_y < child_y){		/* Ｐ򲼤˰ư */
		for(i = 0 ; i <= p->depth_number ; i++){
		    rt_labels = rt_labels->next;
		    move_down(rt_labels,child_y - label_y);
		}
		parent_next_y += child_y - label_y;
	    }else{				/* ʬ򲼤˰ư */
		for(rt = rt->next ; rt != NULL ; rt = rt->next)
		    move_down(rt,label_y - child_y);
		next_y += label_y - child_y;
		child_y += label_y - child_y;
	    }

	    bottom = parent_next_y;
	}

	if(count > 1){
	    allocate(NULL,x,prev_y,w,child_y - prev_y,If);
	    if(count == 2)
		lp->flag1 = On;
	    if(count == ptr->child_number)
		lp->flag2 = On;
	}

	if(none == Off)
	    allocate(NULL,x + w,child_y,hspace,0,Line);	/*  */

	prev_y = child_y;
    }

    if(ptr->child_number == 1){			/* ʬ褬 */
	h = greater(if_height,parent_next_y - top);
	allocate(NULL,x,top,w,h,If);
	lp->flag1 = On; lp->flag2 = On;
	bottom = top + h;
    }

    next_y = greater(next_y,bottom + vspace);
    return (top + bottom) / 2;
}

void print_title(void)
/* 祿ȥν */
{
    PAD pad;
    int dx;

    change_font(title_rate);
    pad.type = Title;
    pad.str = title;
    refold_pad(&pad,page_width);
    allocate(title,x_center,next_y,get_str_width(&pad),get_str_height(&pad),Title);
    dx = - lp->w / 2;
    move_right(lp,dx);
    next_y += lp->h + pad_vspace;
    restore_font();
}

void print_padtitle(PAD *ptr)
/* УĤΥȥν */
{
    int dx;

    change_font(padtitle_rate);
    refold_pad(ptr,page_width);
    allocate(ptr->str,x_center,next_y,get_str_width(ptr),get_str_height(ptr),Padtitle);
    dx = - lp->w / 2;
    move_right(lp,dx);
    next_y += lp->h + vspace * 2;
    restore_font();
}

void print_figure(char *str)
/* Figureν */
{
    PAD pad;
    char *p,tmp[20];
    int l,dx;

    sprintf(tmp,"Figure %d",figure);
    if(str != NULL  &&  titlebox == Off)
        strcat(tmp,":  ");

    l = strlen(tmp);
    p = (char *)malloc((l+2) * sizeof(char));
    strcpy(p,tmp);

    if(str != NULL  &&  titlebox == Off)
	p = joint(2,p,str);

    change_font(figure_rate);
    pad.type = Figure;
    pad.str = p;
    refold_pad(&pad,page_width);
    allocate(p,x_center,next_y,get_str_width(&pad),get_str_height(&pad),Figure);
    dx = - lp->w / 2;
    move_right(lp,dx);
    restore_font();

    figure++;
    next_y += lp->h + vspace;
}

void print_padframe(int y)
/* УĤȤ */
{
    int lx,rx;

    next_y += padframe_vspace - vspace;

    if(centering == On){
        most_left -= padframe_hspace;
	most_right += padframe_hspace;
	lx = most_left;
	rx = most_right;
    }else{
        most_left -= page_left;
        most_right += page_left;
        lx = - page_left;
	rx = greater(lx + (int)((double)(X_MAX / hrate)),most_right);
    }

    allocate(NULL, lx, y, rx - lx, 0 ,Padframe);
    allocate(NULL, lx, y, 0, next_y - y, Padframe);
    allocate(NULL, rx, y, 0, next_y - y, Padframe);
    allocate(NULL, lx, next_y, rx - lx, 0, Padframe);

    next_y += vspace;
}

void print_pagenumber(void)
/* ڡֹν */
{
    fprintf(stderr,"[%d]\n",page+(++page_number));
}

void centerize(BOX *ptr)
/* ˽ */
{
    BOX *p;

    if(ptr == NULL)
	p = first;
    else
	p = ptr->next;

    for( ; p != NULL ; p = p->next)
        move_right(p,- (most_right + most_left) / 2);
}

void check_overflow(int left,int right)
/* ΤϤ߽Фå */
{
    most_left = smaller(most_left,left);
    most_right = greater(most_right,right);
}

double calc_hrate(void)
/* Ŭ hrate  */
{
    double r;

    r = (double)X_MAX / (double)(most_right - most_left);

    if(r < 0.0)
	return proper_hrate;
    else if(r >= hrate)
	return r;
    else
	return r * 0.999;
}

void move_down(BOX *p,int dy)
/* УĤ򲼤˰ư */
{
    STRING *s;

    p->y += dy;
    if(p->str != NULL){
	for(s = p->str ; s != NULL ; s = s->next)
	    s->y += dy;
    }
}

void move_right(BOX *p,int dx)
/* УĤ򱦤˰ư */
{
    STRING *s;

    p->x += dx;
    if(p->str != NULL){
	for(s = p->str ; s != NULL ; s = s->next)
	    s->x += dx;
    }
}

void pad_allocate(PAD *ptr,int x0,int y0)
/* ꥹȤɲáڹ¤ */
{
    int x,y,w,h;

    x = x0; y = y0;

    if(first == NULL){
        first = (BOX *)malloc(sizeof(BOX));
	lp = first;
	lp->prev = NULL;
    }else{
        BOX *prev;
	prev = lp;
        lp->next = (BOX *)malloc(sizeof(BOX));
	lp = lp->next;
	lp->prev = prev;
    }
    lp->next = NULL;

    lp->x = x;
    lp->y = y;
    lp->w = get_str_width(ptr);
    lp->h = 0;
    lp->flag1 = Off;
    lp->flag2 = Off;

    switch(ptr->type){
	case Padtitle:
	    lp->type = Box;
	    x += box_hspace + sideline_space;
	    y += box_vspace;
	    lp->w += box_hspace * 2 + sideline_space * 2;
	    lp->h += box_vspace * 2;
	    lp->flag1 = On;
	    lp->flag2 = On;
	    break;
	case Box:
	    lp->type = Box;
	    x += box_hspace;
	    y += box_vspace;
	    lp->w += box_hspace * 2;
	    lp->h += box_vspace * 2;
	    break;
	case Label:
	    x += linewidth;
	    lp->w += linewidth;
	case Refer:
	    lp->type = Label;
	    w = (int)((double)lp->w * (SQRT2 - 1.0));
	    h = (int)((double)get_str_height(ptr) * (SQRT2 - 1.0));
	    x += w / 2;
	    y += h / 2;
	    lp->w += w;
	    lp->h += h;
	    break;
	case For:
	case While:
	    lp->type = Box;
	    x += box_hspace + sideline_space;
	    y += box_vspace;
	    lp->w += box_hspace * 2 + sideline_space;
	    lp->h += box_vspace * 2;
	    lp->flag1 = On;
	    break;
	case Do:
	    lp->type = Box;
	    x += box_hspace;
	    y += box_vspace;
	    lp->w += box_hspace * 2 + sideline_space;
	    lp->h += box_vspace * 2;
	    lp->flag2 = On;
	    break;
	case Cond:
	    lp->type = Str;
	    break;
    }

    if(ptr->str == NULL)
	lp->str = NULL;
    else{
	lp->str = string(ptr->str,x,y,get_str_width(ptr));
	lp->h += get_str_height(ptr);
    }

    check_overflow(lp->x,lp->x + lp->w);
}

void allocate(char *s,int x,int y,int w,int h,TYPE type)
/* ꥹȤɲ */
{
    if(first == NULL){
        first = (BOX *)malloc(sizeof(BOX));
	lp = first;
	lp->prev = NULL;
    }else{
        BOX *prev;
	prev = lp;
        lp->next = (BOX *)malloc(sizeof(BOX));
	lp = lp->next;
	lp->prev = prev;
    }
    lp->next = NULL;

    lp->type = type;
    lp->x = x;
    lp->y = y;
    lp->w = w;
    lp->h = h;
    lp->flag1 = Off;
    lp->flag2 = Off;

    if(s != NULL)
	lp->str = string(s,x,y,w);
    else
	lp->str = NULL;

    if( ! (type == Title  ||  type == Figure  ||
	  (type == Padtitle  &&  titlebox == Off)))
	check_overflow(lp->x,lp->x + lp->w);
}
