/*                                  */
/*  fold.c -- УĤμưޤʤ  */
/*                                  */
/*  pad2ps  by S. Yoshida           */
/*                                  */

#include "config.h"

#include <string.h>
#include <math.h>
#include "pad2ps.h"
#include "lib.h"

static int total_amount = 0;

static void init_to_fold(void);
static void set_pagewidth(void);
static INT2 setting_tree(PAD *);
static void set_length(PAD *);

static void auto_fold(PAD *);
static PAD *find_fold(PAD *);
static void fold_pad(PAD *);

static void set_whole_width(PAD *);
static int over_maxlength(PAD *);

void fold(void)
/* УĤμưޤʤ */
{
    PAD *ptr,*p;
    int childs,amount;

#ifdef DEBUG
    if(quiet == Off)
        fprintf(stderr,"Automatic folding starts...");
#endif

    init_to_fold();

    for(ptr = root->next ; ptr != NULL ; ptr = ptr->next){
	if(titlebox == On){		/* ȥޤʤ */
	    push(ptr->child); ptr->child = NULL;
	    childs = ptr->child_number; ptr->child_number = 0;
	    amount = ptr->amount;

	    auto_fold(ptr);

	    ptr->child = pop(); ptr->child_number = childs;
	    ptr->amount = amount;
	}
	total_amount++;

	for(p = ptr->child ; p != NULL ; p = p->next){
	    auto_fold(p);
	    total_amount += p->amount;
	}
    }

    if(quiet == Off)
	fputs("0% |*************************************************| 100%\n",stderr);

#ifdef DEBUG
    if(quiet == Off)
        fprintf(stderr,"done\n");
#endif
}

void init_to_fold(void)
/*  */
{
    PAD *ptr;

    set_pagewidth();
    setting_tree(root);
    root->amount = 0;
    for(ptr = root->next ; ptr != NULL ; ptr = ptr->next){
	root->amount += ptr->amount;
    }
}

void set_pagewidth(void)
/* ڡʤɤ */
{
    if(centering == On){
	x_center = 0;
	left_limit = 0;
	right_limit = X_MAX;
    }else{
	x_center = (int)((double)X_CENTER / hrate) - page_left;
	left_limit = page_left;
	right_limit = page_right;
    }
    left_limit = (int)((double)(left_limit / hrate));
    right_limit = (int)((double)(right_limit / hrate));

    if(padframe == On){
	if(centering == On)
	    right_limit -= padframe_hspace * 2;
	else
	    right_limit -= page_left * 2;
    }

    page_width = right_limit - left_limit;
}

INT2 setting_tree(PAD *rt)
/* ڹ¤ν */
{
    PAD *ptr,*p;
    INT2 t,tc;

    t.count = 0;
    t.amount = 0;

    for(ptr = rt ; ptr != NULL ; ptr = ptr->next){
	t.count++;
	ptr->amount = 1;

	set_length(ptr);

	if(ptr->child != NULL){
	    tc = setting_tree(ptr->child);
	    ptr->child_number = tc.count;
	    ptr->amount += tc.amount;
	}

	if(ptr->depth != NULL){
	    for(p = ptr->depth ; p != NULL ; p = p->depth){
		ptr->depth_number++;
		ptr->amount++;

		set_length(p);
		p->child_number = ptr->child_number;
	    }
	}

	t.amount += ptr->amount;
    }

    return t;
}

void set_length(PAD *ptr)
/* ƣУĤβʤɤ */
{
    ptr->lines = 1;
    ptr->child_number = 0;
    ptr->depth_number = 0;
    ptr->enable_fold = On;

    switch(ptr->type){
	case Root:
	case Empty:
	case Newpage:
	case Vsp:
	case Str:
	    ptr->space_width = 0;
	    break;
	case Message:
	case Comment:
	    ptr->space_width = box_hspace;
	    break;
	case Block:
	case Box:
	    ptr->space_width = box_hspace * 2;
	    break;
	case Label:
	    ptr->space_width = linewidth + (int)((double)get_str_width(ptr) * (SQRT2 - 1.0));
	    break;
	case Refer:
	    ptr->space_width = box_hspace * 3 + (int)((double)get_str_width(ptr) * (SQRT2 - 1.0));
	    break;
	case Padtitle:
	    if(titlebox == On)
		ptr->space_width = box_hspace * 2 + sideline_space * 2;
	    else
		ptr->space_width = 0;
	    break;
	case For:
	case While:
	case Do:
	    ptr->space_width = box_hspace * 2 + sideline_space + hspace;
	    break;
	case If:
	case Switch:
	    ptr->space_width = hspace;
	    break;
	case Cond:
	    ptr->space_width = box_hspace * 2 + if_rightspace;
	    break;
    }
}

void auto_fold(PAD *rt)
/* Уʸޤʤμư */
{
    PAD *p;
    char buf[BUFSIZ];
    int i,flag = 0;

    set_whole_width(rt);

    while(rt->whole_width > page_width  &&  poster == Off){
      /* ˤϤ߽Фַ֤ */
	if(quiet == Off){
	    flag = (flag + 1) % 2;
	    strcpy(buf,"0% |----+----+----+----+----+----+----+----+----+----| 100%\r");
	    for(i = 0 ; i < (flag > 0 ? total_amount + rt->amount : total_amount) * 100 / root->amount / 2 ; i++)
		buf[4+i] = '*';
	    fputs(buf,stderr);
	}

	p = find_fold(rt);
	if(p != NULL){
	    fold_pad(p);
	    set_whole_width(rt);
	}else
	    return;
    }
}

PAD *find_fold(PAD *rt)
/* ޤʤ٤УĤõ */
{
    PAD *ptr,*p;
    PAD *p_max = NULL;
    int w;
    int max = 0;

    if(rt->str != NULL  &&  rt->enable_fold == On){
	p_max = rt;
	max = get_str_width(rt);
	if(is_box(rt)  &&  max > max_length)
	    max = INFINITY;
	else if(rt->child_number > 1)
	    max *= (int)sqrt((double)rt->child_number);
    }

    if(rt->child != NULL){
	for(ptr = rt->child ; ptr != NULL ; ptr = ptr->next){
	    p = find_fold(ptr);
	    if(p != NULL){
		w = get_str_width(p);
		if(is_box(p)  &&  w > max_length)
		    w = INFINITY;
		else if(p->child_number > 1)
		    w *= (int)sqrt((double)p->child_number);
		if(w > max){
		    p_max = p;
		    max = w;
		}
	    }
	}
    }

    if(rt->depth != NULL){
	for(ptr = rt->depth ; ptr != NULL ; ptr = ptr->depth){
	    p = find_fold(ptr);
	    if(p != NULL){
		w = get_str_width(p);
		if(is_box(p)  &&  w > max_length)
		    w = INFINITY;
		else if(p->child_number > 1)
		    w *= (int)sqrt((double)p->child_number);
		if(w > max){
		    p_max = p;
		    max = w;
		}
	    }
	}
    }

    return p_max;
}

void fold_pad(PAD *ptr)
/* УĤޤʤ */
{
    int w,fw;

    fw = fontwidth;
#ifdef JAPANESE
    if(include_euc(ptr->str))
	fw = greater(fw,jfontwidth);
#endif

    ptr->lines++;
    w = get_str_width(ptr);
    if(w < min_length  ||  w < fw){
	ptr->enable_fold = Off;
	ptr->lines--;
	w = get_str_width(ptr);
    }

    /* ٥롢Ȥξ϶Ѳ */
    if (ptr->type == Label  ||  ptr->type == Refer) {
	switch (ptr->type) {
	    case Label:
		ptr->space_width = linewidth + (int)((double)get_str_width(ptr) * (SQRT2 - 1.0));
		break;
	    case Refer:
		ptr->space_width = box_hspace * 3 + (int)((double)get_str_width(ptr) * (SQRT2 - 1.0));
		break;
	}
    }
}

void set_whole_width(PAD *rt)
/* rt ʲΣУĤ */
{
    PAD *ptr;
    int m,max = 0,label_max = 0;

    if(rt->child == NULL)
	rt->whole_width = get_str_width(rt) + rt->space_width;
    else{
	if(rt->type == If  ||  rt->type == Switch){	/* ʬ٥κĹõ */
	    for(ptr = rt->child ; ptr != NULL ; ptr = ptr->next)
		label_max = greater(label_max,get_str_width(ptr));
	}

	for(ptr = rt->child ; ptr != NULL ; ptr = ptr->next){
	    set_whole_width(ptr);
	    if(rt->type == If  ||  rt->type == Switch)
		ptr->whole_width += (label_max - get_str_width(ptr));
	    max = greater(max,ptr->whole_width);
	}

	if(rt->type == Block  ||  rt->type == Refer)
	    m = 0;
	else
	    m = get_str_width(rt) + rt->space_width;

	if(rt->depth != NULL){
	    for(ptr = rt->depth ; ptr != NULL ; ptr = ptr->depth){
		set_whole_width(ptr);
		m = greater(m,ptr->whole_width);
	    }
	}

	if(rt->type == Block  ||  rt->type == Refer)
	    m += get_str_width(rt) + rt->space_width;

	rt->whole_width = max + m;
    }
}

int over_maxlength(PAD *rt)
/* rt ʲ max_length ۤΤ뤫 */
{
    PAD *ptr;

    if(rt->child == NULL){
	if(is_box(rt)  &&  get_str_width(rt) > max_length)
	    return 1;
    }else{
	for(ptr = rt->child ; ptr != NULL ; ptr = ptr->next){
	    if(over_maxlength(ptr))
		return 1;
	}

	if(rt->depth != NULL){
	    for(ptr = rt->depth ; ptr != NULL ; ptr = ptr->depth){
		if(over_maxlength(ptr))
		    return 1;
	    }
	}
    }

    return 0;
}

void refold_pad(PAD *p,int max)
/* ޤʤκƷ׻ */
{
    int w,fw;

    if(poster == On)
	max = INFINITY;

    fw = fontwidth;
#ifdef JAPANESE
    if(include_euc(p->str))
	fw = greater(fw,jfontwidth);
#endif

    p->lines = 1;
    w = get_str_width(p);
    while(w > max  ||  (is_box(p)  &&  w > max_length)){
	p->lines++;
	w = get_str_width(p);
	if(w < min_length  ||  w < fw){
	    p->lines--;
	    w = get_str_width(p);
	    return;
	}
    }
}

int is_box(PAD *p)
/* Уĥܥåˤʤ뤫 */
{
    switch(p->type){
	case Root:
	case Title:
	case Figure:
	case Empty:
	case Newpage:
	case Vsp:
	    return 0;
	case Padtitle:
	    if(titlebox == Off)
		return 0;
    }

    return 1;
}
