/*                                 */
/*  token.c -- ȡڤФ  */
/*                                 */
/*  c2pad  by S. Yoshida           */
/*                                 */

#include "config.h"

#include <string.h>
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#include <ctype.h>
#include "c2pad.h"
#include "lib.h"

#define PRINT_COMMENT_IMMEDIATELY

static int ch = 0;
static int pch = 0;		/* ʸɤ */
static int word_ptr = 0;	/* word ΰ */
static bool newline = On;	/* Ƭɤ */
static char *comm = NULL;	/* ¸ */

static void set_ch(void);
static void append_ch(void);
static void get_ch(void);

#ifndef PRINT_COMMENT_IMMEDIATELY
static void preserve_comment(void);
#endif

void get_token(void)
/* ȡڤФ */
{
    int old_ch;

    if(token == Eof)
	fatal_error("input file terminates unexpectedly.");

#ifndef PRINT_COMMENT_IMMEDIATELY
    if(newline == On  &&  comm != NULL){
	/* ¸Ȥν */

	/* ξǤϽϤʤ */
	if (no_print_comment_flag == On) {
	    strcpy(word,comm);
	    free(comm);
	    comm = NULL;
	    token = Comment;
	    return;
	}

	printf("%s",comm);
	free(comm);
	comm = NULL;
    }
#endif

    if(ch == 0)
	get_ch();

    switch(ch){
	case EOF:
	    token = Eof;
	    *word = '\0';
	    return;
	case '\n':
	    newline = On;
	    token = Ret;
	    set_ch();
	    get_ch();
	    return;
	case ' ':
	case '\t':
	    token = Sp;
	    set_ch();
	    get_ch();
	    while(ch == ' '  ||  ch == '\t'){
		append_ch();
		get_ch();
	    }
	    return;
	case '#':
	    if(newline == On){
		if(ifdef == On){		/* -ifdef λ */
		    token = Sharp;
		    get_ch();
		    return;
		}else{
		    get_ch();
		    eval_ifdef();		/* #ifdef ν */
		    return;
		}
	    }else{			/* ʸƬʳ '#' */
		token = Str;
		set_ch();
		get_ch();
		return;
	    }
	case '/':
	    set_ch();
	    get_ch();
	    if(ch != '*'  &&  ch != '/'){
		newline = Off;
		token = Divide;
		return;
	    }else if(ch == '*'){	/* äΥ */
		append_ch();
		get_ch(); append_ch();

		do{
		    old_ch = ch;
		    get_ch(); append_ch();
		}while(old_ch != '*'  ||  ch != '/');

		get_ch();

#ifndef PRINT_COMMENT_IMMEDIATELY
		if(newline == On){	/* ƬΥȤʤ¨ */
#endif
		    if(ifdef == Off  &&  ifdef_value == TRUE){
			/* ξǤϽϤʤ */
			if (no_print_comment_flag == On) {
#ifdef PRINT_COMMENT_IMMEDIATELY
			    if(newline == Off)
				strcat(word,"\n");
#endif
			    token = Comment;
			    return;
			}

#ifdef PRINT_COMMENT_IMMEDIATELY
			if (elseif_flag == On) {
			    putchar('\n');
			    elseif_flag = Off;
			}
#endif
			puts(word);
		    }

#ifdef PRINT_COMMENT_IMMEDIATELY
		    if(newline == Off){
			get_token();
			return;
		    }
#endif
		    get_token();
		    while(token == Sp)
			get_token();
		    if(token == Ret)
			get_token();
#ifndef PRINT_COMMENT_IMMEDIATELY
		}else{		/* ¾ΥȤ¸ơԤθǽ */
		    if(ifdef == Off  &&  ifdef_value == TRUE)
			preserve_comment();
		    get_token();
		}
#endif
		return;
	    }else{			/* áܡܤΥ */
		append_ch();
		get_ch();

		while(ch != '\n'){
		    append_ch();
		    get_ch();
		}

#ifndef PRINT_COMMENT_IMMEDIATELY
		if(newline == On){	/* ƬΥȤʤ¨ */
#endif
		    if(ifdef == Off  &&  ifdef_value == TRUE){
			/* ξǤϽϤʤ */
			if (no_print_comment_flag == On) {
			    get_ch();
			    strcat(word,"\n");
			    token = Comment;
			    return;
			}

#ifdef PRINT_COMMENT_IMMEDIATELY
			if (elseif_flag == On) {
			    putchar('\n');
			    elseif_flag = Off;
			}
#endif
			puts(word);
		    }

#ifdef PRINT_COMMENT_IMMEDIATELY
		    if(newline == On)
#endif
		    get_ch();
		    get_token();
#ifndef PRINT_COMMENT_IMMEDIATELY
		}else{		/* ¾ΥȤ¸ơԤθǽ */
		    if(ifdef == Off  &&  ifdef_value == TRUE)
			preserve_comment();
		    get_token();
		}
#endif
		return;
	    }
	case '"':
	    newline = Off;
	    set_ch();

	    do{
		get_ch();
		if(ch == '\n'){
		    ch = '\\'; append_ch();
		    ch = 'n'; append_ch();
		}else if(ch == '\\'){
		    append_ch();
		    get_ch(); append_ch();
		    ch = ' ';
		}else
		    append_ch();
	    }while(ch != '"');

	    get_ch();

	    token = Str;
	    return;
	case '\'':
	    newline = Off;
	    set_ch();

	    do{
		get_ch();
		if(ch == '\n'){
		    ch = '\\'; append_ch();
		    ch = 'n'; append_ch();
		}else if(ch == '\\'){
		    append_ch();
		    get_ch(); append_ch();
		    ch = ' ';
		}else
		    append_ch();
	    }while(ch != '\'');

	    get_ch();

	    token = Str;
	    return;
	case '<':
	    newline = Off;
	    set_ch();
	    get_ch();
	    switch(ch){
		case '<':
		    token = Lshift;
		    append_ch();
		    get_ch();
		    return;
		case '=':
		    token = Less_eq;
		    append_ch();
		    get_ch();
		    return;
		default:
		    token = Less;
		    return;
	    }
	case '>':
	    newline = Off;
	    set_ch();
	    get_ch();
	    switch(ch){
		case '>':
		    token = Rshift;
		    append_ch();
		    get_ch();
		    return;
		case '=':
		    token = Great_eq;
		    append_ch();
		    get_ch();
		    return;
		default:
		    token = Great;
		    return;
		}
	case '&':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if(ch != '&'){
		token=And;
		return;
	    }else{
		token = And2;
		append_ch();
		get_ch();
		return;
	    }
	case '|':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if(ch != '|'){
		token = Or;
		return;
	    }else{
		token = Or2;
		append_ch();
		get_ch();
		return;
	    }
	case '=':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if(ch != '='){
		token = Equal;
		return;
	    }else{
		token = Equal2;
		append_ch();
		get_ch();
		return;
	    }
	case '!':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if(ch != '='){
		token = Not;
		return;
	    }else{
		token = Neq;
		append_ch();
		get_ch();
		return;
	    }
	case '^':
	    newline = Off;
	    token = Exp;
	    set_ch();
	    get_ch();
	    return;
	case '*':
	    newline = Off;
	    token = Times;
	    set_ch();
	    get_ch();
	    return;
	case '+':
	    newline = Off;
	    token = Plus;
	    set_ch();
	    get_ch();
	    return;
	case '-':
	    newline = Off;
	    token = Minus;
	    set_ch();
	    get_ch();
	    return;
	case '(':
	    newline = Off;
	    token = Lpar;
	    set_ch();
	    get_ch();
	    return;
	case ')':
	    newline = Off;
	    token = Rpar;
	    set_ch();
	    get_ch();
	    return;
	case '{':
	    newline = Off;
	    token = Lbrace;
	    set_ch();
	    get_ch();
	    return;
	case '}':
	    newline = Off;
	    token = Rbrace;
	    set_ch();
	    get_ch();
	    return;
	case '[':
	    newline = Off;
	    token = Lbracket;
	    set_ch();
	    get_ch();
	    return;
	case ']':
	    newline = Off;
	    token = Rbracket;
	    set_ch();
	    get_ch();
	    return;
	case '?':
	    newline = Off;
	    token = Question;
	    set_ch();
	    get_ch();
	    return;
	case ':':
	    newline = Off;
	    set_ch();
	    get_ch();
	    if(ch != ':'){
		token = Colon;
		return;
	    }else{
		token = Colon2;
		append_ch();
		get_ch();
		return;
	    }
	case ';':
	    newline = Off;
	    token = Semicolon;
	    set_ch();
	    get_ch();
	    return;
	default:
	    newline = Off;
	    if(isdigit(ch)){
		token = Num;
		set_ch();
		get_ch();
		while(isdigit(ch)){
		    append_ch();
		    get_ch();
		}
		return;
	    }

	    if(isalpha(ch)  ||  ch == '_'){
		token = Name;
		set_ch();
		get_ch();
		while(isalnum(ch)  ||  (char)ch == '_'){
		    append_ch();
		    get_ch();
		}

		if(strcmp(word,"if") == 0)
		    token = If;
		else if(strcmp(word,"else") == 0)
		    token = Else;
		else if(strcmp(word,"while") == 0)
		    token = While;
		else if(strcmp(word,"for") == 0)
		    token = For;
		else if(strcmp(word,"do") == 0)
		    token = Do;
		else if(strcmp(word,"switch") == 0)
		    token = Switch;
		else if(strcmp(word,"case") == 0)
		    token = Case;
		else if(strcmp(word,"default") == 0)
		    token = Default;
		else if(strcmp(word,"return") == 0)
		    token = Return;
		else if(strcmp(word,"break") == 0)
		    token = Break;
		else if(strcmp(word,"continue") == 0)
		    token = Continue;
		else if(strcmp(word,"goto") == 0)
		    token = Goto;
		else if(strcmp(word,"public") == 0)
		    token = Public;
		else if(strcmp(word,"private") == 0)
		    token = Private;
		else if(strcmp(word,"protected") == 0)
		    token = Protected;
		else if(strcmp(word,"ifdef") == 0)
		    token = Ifdef;
		else if(strcmp(word,"ifndef") == 0)
		    token = Ifndef;
		else if(strcmp(word,"elif") == 0)
		    token = Elif;
		else if(strcmp(word,"endif") == 0)
		    token = Endif;
		else if(strcmp(word,"define") == 0)
		    token = Define;
		else if(strcmp(word,"undef") == 0)
		    token = Undef;
		else if(strcmp(word,"defined") == 0)
		    token = Defined;

		return;
	    }

	    token = Str;
	    set_ch();
	    get_ch();
	    return;
    }
}

void set_ch(void)
/* ɤʸΥå */
{
    *word = ch;
    *(word + 1) = '\0';
    word_ptr = 1;
}

void append_ch(void)
/* ɤʸɲ */
{
    *(word + word_ptr) = ch;
    *(word + word_ptr + 1) = '\0';
    word_ptr++;
}

void get_ch(void)
/* ʸɤ */
{
    if(ch == 0){
	ch = getc(input_stream);
	pch = getc(input_stream);
    }else{
	ch = pch;
	pch = getc(input_stream);
    }

    while(ch == '\\'  &&  pch == '\n'){		/* ʸ '\' ɤ߼ΤƤ */
	line_count++;
	ch = getc(input_stream);
	pch = getc(input_stream);
    }

    if(ch == '\n')
	line_count++;
}

#ifndef PRINT_COMMENT_IMMEDIATELY
void preserve_comment(void)
/* Ȥ¸ */
{
    char *s;
    int l;

    l = strlen(word);
    s = (char *)malloc((l+3) * sizeof(char));
    strcpy(s,word);
    strcat(s,"\n");

    if(comm == NULL)
	comm = s;
    else
	comm = joint(2,comm,s);
}
#endif
