/*                        */
/*  c2pad.h               */
/*                        */
/*  c2pad  by S. Yoshida  */
/*                        */

#ifndef _C2PAD_H
#define _C2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* ̵ϱѸǤ */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

#define TRUE		((void *)10)	/* #ifdef ʤɤο */
#define FALSE		((void *)11)
#define ABS_FALSE	((void *)12)
#define TRUED_FALSE	((void *)13)


typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num,
    Lpar, Rpar, Lbrace, Rbrace, Lbracket, Rbracket,
    Colon, Colon2, Semicolon,
    Sharp, Question,
    Equal, Equal2, Neq, Less, Great, Less_eq, Great_eq,
    Not, And, Or, And2, Or2,
    Plus, Minus, Times, Divide, Exp, Lshift, Rshift,
    If, Else, While, For, Do, Switch, Case, Default,
    Return, Break, Continue, Goto,
    Public, Private, Protected,
    Ifdef, Ifndef, Elif, Endif, Define, Undef, Defined
} token_type;

typedef struct _DEF DEF;

struct _DEF {
    char *sym;
    int val;
    DEF *next;
};


extern token_type token;	/* ȡ */
extern char word[];		/* ɤʸ */

extern bool no_print_comment_flag;	/* Ȥ򤽤ξɽʤ */
extern bool elseif_flag;		/* else if ν椫 */

extern int tab;			/*  */
extern bool optimize;		/* -O ץ */
extern bool semicolon;		/* -semicolon ץ */
extern bool inline_flag;	/* -inline ץ */

extern bool ifdef;		/* -ifdef ץ */

extern DEF *defined_list;	/* ܥΥꥹ */
extern void *ifdef_value;	/* ߤ #ifdef  */

extern bool debug;		/* -debug ץ */
extern bool quiet;		/* -quiet ץ */
extern bool print_warning;	/* warningϤ뤫 */
extern int line_count;		/* Ƥ */

extern FILE *input_stream;	/* ϥե */


/* ifdef.c */
extern void list_defines(void);		/* #ifdef ǹθܥΰɽ */
extern void eval_ifdef(void);		/* #ifdef ν */
extern void add_symbol(char *,int);	/* ܥϿ */

/* parser.c */
extern void parser(void);		/*  */

/* token.c */
extern void get_token(void);		/* ȡڤФ */

#endif  /* ! _C2PAD_H */
