/*                                                   */
/*  parser.c -- AWK program  PADEL Ѵƽ  */
/*                                                   */
/*  awk2pad  by S. Yoshida                           */
/*                                                   */

#include "config.h"

#include <string.h>
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#include <ctype.h>
#include "awk2pad.h"
#include "lib.h"

#define MAKE_STRING_WHILE(X)	{\
				    count_paren = 0;\
				    set_str();\
				    get_token();\
				    while(X){\
					if(token == Ret){\
					    append(" ");\
					    *sp = '\0';\
					    do{\
						get_token();\
					    }while(token == Sp);\
					}else{\
					    if(token == Sp){\
						strcat(sp,word);\
					    }else{\
						if(token == Lpar)\
						     count_paren--;\
						if(token == Rpar)\
						     count_paren++;\
						if(*sp != '\0')\
						    append(sp);\
						*sp = '\0';\
						append_str();\
					    }\
					    get_token();\
					}\
				    }\
				    if(*sp != '\0')\
					append(sp);\
				    *sp = '\0';\
				}

#define END_OF_LINE()		{\
				    tt = token; get_token();\
				     while(token == Sp)\
					get_token();\
				    if(tt != Ret  &&  token == Ret)\
					get_token();\
				}

static char *str = NULL;
static int nest_level = 0;
static int count_paren = 0;
static token_type tt = Nontoken;

static void function(void);
static void body(void);
static void command(void);
static void for_statement(void);
static void else_statement(void);
static void do_statement(void);
static void condition(void);

static void set_str(void);
static void append_str(void);
static void append(char *);
static void print_str(void);
static void print_hsp(void);

void parser(void)
/*  */
{
#ifdef DEBUG
    if(quiet == Off)
	fprintf(stderr,"Translating AWK program into PADEL starts...");
#endif

    get_token();

    while(token != Eof){
	while(token == Sp)
	    get_token();

	if(token == Ret){               /*  */
	    putchar('\n');
	    get_token();
	}else if(token != Eof)
	    function();			/* ѥ󡢴ؿ */
    }

#ifdef DEBUG
    if(quiet == Off)
	fprintf(stderr,"done\n");
#endif
}

void function(void)
/* ѥ󡢴ؿ */
{
    char sp[BUFSIZ] = {'\0'};
    char buf[BUFSIZ];
    int p;

    str = NULL;
    if(token != Lbrace){
	MAKE_STRING_WHILE(token != Lbrace  &&  token != Eof);
	print_str();
	putchar('\n');
    }
    puts("{");

    nest_level++;
    body();
    nest_level--;

    puts("}");

    END_OF_LINE();
}

void body(void)
{
    char sp[BUFSIZ] = {'\0'};

    get_token();
    END_OF_LINE();

    while(token != Rbrace  &&  token != Eof){
	switch(token){
	    case Ret:			/*  */
		putchar('\n');
		get_token();
		break;
	    case Lbrace:		/* { } ǰϤޤƤ */
		body();
		END_OF_LINE();
		break;
	    default:
		command();
	}

        while(token == Sp)
            get_token();
    }

    get_token();
}

void command(void)
{
    char sp[BUFSIZ] = {'\0'};
    char buf[BUFSIZ];
    int i,p;

    switch(token){
	case For:
	case While:
	case If:
	    for_statement();
	    break;
	case Do:
	    do_statement();
	    break;
	case Semicolon:
	    print_hsp();
	    printf("{    }\n");
	    END_OF_LINE();
	    break;
	default:
	    MAKE_STRING_WHILE(token != Semicolon  &&  token != Ret  &&  token != Rbrace  &&  token != Eof);
	    print_hsp();
	    print_str();
	    putchar('\n');
	    if(token != Rbrace)
		END_OF_LINE();
    }
}

void for_statement(void)
{
    char *old_str, sp[BUFSIZ] = {'\0'};
    char ret_buf[BUFSIZ] = {'\0'}, comm_buf[BUFSIZ] = {'\0'};
    bool ret_flag = Off;
    token_type type;
    int i,sp_len,ret_count = 0;

    type = token;

    old_str = str;
    MAKE_STRING_WHILE(token != Lpar);
    if(elseif_flag == On)	/* else ³ʸ */
	str = joint(2,old_str,str);
    condition();
    while(token == Sp  ||  token == Ret){
	if(token == Sp)
	    strcat(sp,word);
	else if(token == Ret)
	    ret_flag = On;
	get_token();
    }

    if(elseif_flag == On)	/* else if λϹƬΥڡ */
	elseif_flag = Off;
    else
	print_hsp();

    print_str();

    if(token == Lbrace){
	if(ret_flag == On){
	    putchar('\n');
	    print_hsp();
	    printf("{\n");
	}else
	    printf("%s{\n",sp);

	nest_level++;
	body();				/* ȿ */
	nest_level--;

	if(type != If){
	    print_hsp();
	    printf("}\n");
	    END_OF_LINE();
	}else{
	    sp_len = nest_level * tab;
	    for(i = 0 ; i < sp_len ; i++)
		append(" ");
	    append("}");
	    print_str();
	}

	ret_flag = On;
    }else{
	putchar('\n');
	nest_level++;
	command();
	nest_level--;
	ret_flag = Off;
    }

    *sp = '\0';
    ret_count = 0;
    if(type == If){			/* else뤫ɤ */
	no_print_comment_flag = On;
	while(token == Sp  ||  token == Ret  ||  token == Comment){
	    if(token == Sp){
		strcat(sp,word);
	    }else if(token == Ret){
                ret_count++;
		strcat(ret_buf,"\n");
	    }else if(token == Comment){
		strcat(ret_buf,word);
		strcat(comm_buf,word);
		ret_count++;
	    }
	    get_token();
	}
	no_print_comment_flag = Off;
	if(token != Else){		/* elseʤ */
	    print_str();
	    if(ret_flag == On  &&  ret_count == 0)
		strcpy(ret_buf,"\n");
	    fputs(ret_buf,stdout);
	    return;
	}else{				/* else */
	    sp_len = nest_level * tab;
	    if (*comm_buf != '\0') {
		if(ret_flag == On)
		    putchar('\n');
		fputs(comm_buf,stdout);
	    } else {
		if(ret_flag == On){
		    if(ret_count > 0)
			putchar('\n');
		    else
			sp_len = strlen(sp);
		}
	    }

	    for(i = 0 ; i < sp_len ; i++)
		append(" ");
	    append("else");
	    else_statement();
	}
    }
}

void else_statement(void)
{
    char sp[BUFSIZ] = {'\0'};
    bool ret_flag = Off;

    get_token();
    while(token == Sp  ||  token == Ret){
	if(token == Sp)
	    strcat(sp,word);
	else if(token == Ret)
	    ret_flag = On;
	get_token();
    }

    if(token == If){
	if(ret_flag == Off){		/* else if */
	    append(sp);
	    elseif_flag = On;
	    command();
	}else{
	    print_str();
	    putchar('\n');
	    nest_level++;
	    command();
	    nest_level--;
	}
    }else{
	print_str();
	if(token == Lbrace){
	    if(ret_flag == On){
		putchar('\n');
		print_hsp();
		printf("{\n");
	    }else
		printf("%s{\n",sp);

	    nest_level++;
	    body();			/* ȿ */
	    nest_level--;

	    print_hsp();
	    printf("}\n");

	    END_OF_LINE();
	    return;
	}else{
	    putchar('\n');
	    nest_level++;
	    command();
	    nest_level--;
	}
    }
}

void do_statement(void)
{
    char sp[BUFSIZ] = {'\0'};
    bool ret_flag = Off;

    get_token();
    while(token == Sp  ||  token == Ret){
	if(token == Sp)
	    strcat(sp,word);
	else if(token == Ret)
	    ret_flag = On;
	get_token();
    }

    print_hsp();

    if(token == Lbrace){
	if(ret_flag == On)
	    printf("do\n{\n");
	else
	    printf("do%s{\n",sp);

	nest_level++;
	body();				/* ȿ */
	nest_level--;

	print_hsp();
	printf("}");
    }else{
	printf("do\n");
	nest_level++;
	command();
	nest_level--;
	while(token == Sp  ||  token == Ret)
	    get_token();
	print_hsp();
    }

    *sp = '\0';
    MAKE_STRING_WHILE(token != Lpar);
    condition();

    print_str();
    putchar('\n');

    while(token != Semicolon)
	get_token();
    get_token();
    END_OF_LINE();
}

void condition(void)
{
    char sp[BUFSIZ] = {'\0'};

    append_str();
    get_token();

    while(token != Rpar){
	if(token == Lpar)
	    condition();
	else if(token == Ret){
	    append(" ");
	    *sp = '\0';
	    do{
		get_token();
	    }while(token == Sp);
	}else{
	    if(token == Sp)
		strcat(sp,word);
	    else{
		if(*sp != '\0')
		    append(sp);
		*sp = '\0';
		append_str();
	    }

	    get_token();
	}
    }

    if(*sp != '\0')
	append(sp);
    append_str();
    get_token();
}

void set_str(void)
{
    int l;

    l = strlen(word);
    str = (char *)malloc((l+2) * sizeof(char));
    strcpy(str,word);
}

void append_str(void)
{
    int l;
    char *s;

    l = strlen(word);
    s = (char *)malloc((l+2) * sizeof(char));
    strcpy(s,word);
    str = joint(2,str,s);
}

void append(char *p)
{
    int l;
    char *s;

    l = strlen(p);
    s = (char *)malloc((l+2) * sizeof(char));
    strcpy(s,p);
    str = joint(2,str,s);
}

void print_str(void)
{
    if(str != NULL){
	printf("%s",str);
	free(str);
	str = NULL;
    }
}

void print_hsp(void)
{
    int i;

    for(i = 0 ; i < nest_level * tab ; i++)
	putchar(' ');
}
