/*                         */
/*  sh2pad.h               */
/*                         */
/*  sh2pad  by S. Yoshida  */
/*                         */

#ifndef _SH2PAD_H
#define _SH2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* output in English by default */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num, Function,
    And2, Or2, LL,
    Lpar, Rpar, Plbrace, Lbrace, Rbrace, Lbracket, Rbracket,
    Semicolon, Wsemicolon,
    If, Then, Else, Elif, Fi, For, While, Do, Done,
    Case, In, Esac
} token_type;

typedef struct _NEST NEST;
typedef struct _STR STR;

struct _NEST {
    NEST *parent;
    NEST *child;
    STR *strr;
    STR *strl;
    int nest_level;
};    

struct _STR {
    char *str;
    STR *next;
};


extern token_type token;	/* token */
extern char word[];		/* string just read */

extern bool no_print_comment_flag;	/* does not print comment at this place */

extern int tab;			/* tab width */
extern int global_count_paren;	/* paranthesis */

extern char key[];		/* termination string in cat << EOF */
extern int cat_flag;		/* whether in cat << EOF */

extern NEST *nest;		/* function declaration nesting */
extern NEST *child;		/* child function declaration */

extern bool debug;		/* -debug option */
extern bool quiet;		/* -quiet option */
extern bool print_warning;	/* whether to print warning */
extern int line_count;		/* line in process */

extern FILE *input_stream;	/* input file */


/* parser.c */
extern void parser(void);		/* output */
extern void print(const char *);	/* print string */

/* token.c */
extern void get_token(void);		/* get token */

#endif  /* ! _SH2PAD_H */
