/*                            */
/*  string.c -- treat string  */
/*                            */
/*  pad2ps  by S. Yoshida     */
/*                            */

#include "config.h"

#include <string.h>
#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#include "pad2ps.h"
#include "lib.h"

#ifdef ENGLISH
static STRING *get_string(char *,int,int,int);
#endif
#ifdef JAPANESE
static STRING *get_string(char *,int,int,int,bool);
#endif

STRING *string(char *str,int x0,int y0,int max)
/* create STRING-style data */
{
    STRING *s0,*s = NULL;
    int l,p1,p2 = 0;
    int x,y,dx = 0;
#ifdef JAPANESE
    bool jflag = None;
#endif

    l = strlen(str);
    x = x0; y = y0;

    for(p1 = 0 ; p1 <= l ; p1++){
#ifdef JAPANESE
	if(is_euc(*(str + p1))){	/* Japanese */
	    if(dx + jfontwidth > max  ||  jflag == Off){
		if(s == NULL){
		    s = get_string(str + p2,p1 - p2,x,y,jflag);
		    s0 = s;
		}else{	
		    s->next = get_string(str + p2,p1 - p2,x,y,jflag);
		    s = s->next;
		}
		p2 = p1;
		if(dx + jfontwidth > max){
		    y += fontsize; dx = 0;
		}
		x = x0 + dx;
	    }
	    dx += jfontwidth;
	    jflag = On;
	    p1++;		/* treat for 2 bytes characters */
	}else{				/* alphabets and numerals */
	    if(dx + fontwidth > max  ||  jflag == On  ||  p1 == l){
		if(s == NULL){
		    s = get_string(str + p2,p1 - p2,x,y,jflag);
		    s0 = s;
		}else{	
		    s->next = get_string(str + p2,p1 - p2,x,y,jflag);
		    s = s->next;
		}
#endif
#ifdef ENGLISH
	    if(dx + fontwidth > max  ||  p1 == l){
		if(s == NULL){
		    s = get_string(str + p2,p1 - p2,x,y);
		    s0 = s;
		}else{	
		    s->next = get_string(str + p2,p1 - p2,x,y);
		    s = s->next;
		}
#endif
		p2 = p1;
		if(dx + fontwidth > max){
		    y += fontsize; dx = 0;
		}
		x = x0 + dx;
	    }
	    dx += fontwidth;
#ifdef JAPANESE
	    jflag = Off;
	}
#endif
    }

    return s0;
}

#ifdef ENGLISH
STRING *get_string(char *p,int l,int x,int y)
#endif
#ifdef JAPANESE
STRING *get_string(char *p,int l,int x,int y,bool jflag)
#endif
/* convert string into STRING style */
{
    STRING *s;
    int i;

    s = (STRING *)malloc(sizeof(STRING));

    s->str = (char *)malloc((l+2) * sizeof(char));
    for(i = 0 ; i < l ; i++)
	*(s->str + i) = *(p + i);
    *(s->str + l) = '\0';

    s->x = x;
    s->y = y;
#ifdef JAPANESE
    s->jflag = jflag;
#endif
    s->next = NULL;

    return s;
}

int get_str_ww(char *s)
/* return the width of string */
{
    int i,l,w = 0;

    l = strlen(s);

    for(i = 0 ; i < l ; i++){
#ifdef JAPANESE
        if(is_euc(*(s+i))){
            w += jfontwidth;
	    i++;		/* treat for 2 bytes characters */
	}else
#endif
	    w += fontwidth;
    }

    return w;
}

int get_str_width(PAD *p)
/* return the width of string after folding */
{
    int w,fw,i,l,width,lines;

    if(p->str == NULL)
	return 0;
    else{
	w = (get_str_ww(p->str) - 1) / p->lines + 1;

	l = strlen(p->str);
	fw = fontwidth;
#ifdef JAPANESE
	if(include_euc(p->str))
	    fw = greater(w,jfontwidth);
#endif

	w -= fw;
	do{
	    w += fw;

	    width = 0; lines = 1;
	    for(i = 0 ; i < l ; i++){
#ifdef JAPANESE
		if(is_euc(*(p->str + i))){	/* Japanese */
		    i++;
		    width += jfontwidth;
		    if(width > w){
			lines++;
			width = jfontwidth;
		    }
		}else{				/* alphabets and numerals */
#endif
		    width += fontwidth;
		    if(width > w){
			lines++;
			width = fontwidth;
		    }
#ifdef JAPANESE
		}
#endif
	    }
	}while(lines > p->lines);		/* if sticks out a bit... */

	return w;
    }
}

int get_str_height(PAD *p)
/* return the height of string after folding */
{
    if(p->str == NULL)
	return 0;
    else
	return p->lines * fontsize;
}

int get_str_lines(PAD *p,int w)
/* return the line count after folding */
{
    if(p->str == NULL)
	return 1;
    else
	return (get_str_ww(p->str) - 1) / w + 1;
}
