/*                         */
/*  pad2ps.h               */
/*                         */
/*  pad2ps  by S. Yoshida  */
/*                         */

#ifndef _PAD2PS_H
#define _PAD2PS_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* output in English by default */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

#define SCALE		0.06	/* PostScript scale */
#define SQRT2		1.42	/* used for labeling and calculating radius for handling references */

#define X_MAX		9000	/* right boundary of the paper */
#define Y_MAX		10000	/* upper boundary of the paper */
#define X_CENTER	4500	/* x-coordinate of the center of the paper */
#define PAGE_TOP	9800	/* page top */
#define PAGE_BOTTOM	0	/* page bottom */
#define PAGE_LEFT	500	/* page left */
#define PAGE_RIGHT	8500	/* page right */
#define PAGENUMBER_Y	-1000	/* position where page number is to be printed */
#define INVALID		-50000	/* invalid coordinate */
#define INFINITY	50000	/* infinity */

#define VSPACE		120	/* vertical spacing between boxes */
#define HSPACE		200	/* horizontal spacing between boxes */
#define BOX_VSPACE	25	/* vertical space of normal box */
#define IF_VSPACE	50	/* vertical space of "if" box */
#define BOX_HSPACE	125	/* space in normal box */
#define IF_RIGHTSPACE	200	/* space of "if" box at right side */
#define SIDELINE_SPACE	50	/* spacing between sidelines (used in for statement and others) */
#define PAD_VSPACE	400	/* vertical spacing between PADs */
#define PADFRAME_VSPACE	180	/* vertical spacing between PAD and its frame */
#define PADFRAME_HSPACE	300	/* horizontal spacing between PAD and its frame */

#define LINEWIDTH	16	/* thickness of line */
#define PADLINEWIDTH	16	/* thickness of PAD */
#define FRAMELINEWIDTH	8	/* thickness of frame line */

#define FONTSIZE	200	/* font size (height of characters) */
#define FONTWIDTH	100	/* width of font (alphabets) */
#define JFONTWIDTH	200	/* width of font (japanese characters) */
#define TITLE_RATE	2.0	/* magnification rate of title */
#define PADTITLE_RATE	1.5	/* magnification rate of PAD title */
#define FIGURE_RATE	1.5	/* magnification rate of PAD figure */
#define CHAR_BASEUP	40	/* shift up characters a little */
#define JCHAR_BASEUP	20	/* shift up Japnese characters a little */


typedef struct _PAD PAD;
typedef struct _BOX BOX;
typedef struct _STRING STRING;
typedef struct _INT2 INT2;

typedef enum {
    Root, Title,
    Message, Comment,
    Newpage, Vsp,
    Empty, Str, Box, Figure,
    Padtitle, For, While, Do,
    Block, If, Switch, Cond,
    Label, Refer,
    Line, Padframe,
    Topdown, Middle, Bottomup,
    Top, Bottom
} TYPE;

struct _PAD {
    TYPE type;
    char *str;
    int value;
    int lines;
    int space_width;
    int whole_width;
    int child_number;
    int depth_number;
    int amount;
    bool enable_fold;
    PAD *child;
    PAD *depth;
    PAD *next;
};

struct _BOX {
    TYPE type;
    STRING *str;
    int x;
    int y;
    int w;
    int h;
    bool flag1;
    bool flag2;
    BOX *prev;
    BOX *next;
};

struct _STRING {
    char *str;
    int x;
    int y;
#ifdef JAPANESE
    bool jflag;
#endif
    STRING *next;
};

struct _INT2 {
    int count;
    int amount;
};


extern bool quiet;		/* -quiet option */
#ifdef DEBUG
extern bool debug;		/* -debug option */
#endif

extern bool eps_flag;		/* pad2eps? */
extern bool latex_command_flag;	/* treat string as LaTeX command? */

extern char *title;		/* overall title */
extern bool titlebox;		/* whether to draw each PAD title in box */
extern bool page_print;		/* whether to print page number */
extern int page;		/* <starting page>-1 */
extern int figure;		/* figure number */
extern TYPE figure_locate;	/* figure position */
extern bool figure_locate_flag;	/* whether figure_locate is being set */
extern bool centering;		/* whether to centerize */
extern bool poster;		/* poster */
extern bool slice;		/* whether to draw each PAD from the head of page */

extern int tab_width;		/* tab width */

extern TYPE locate_type;	/* PAD location format */

extern bool pageframe;		/* whether to draw page frame */
extern bool padframe;		/* whether to draw PAD frame */

extern int page_top;		/* page top */
extern int page_bottom;		/* page bottom */
extern int page_left;		/* page left */
extern int page_right;		/* page right */
extern int page_width;		/* page width */
extern int x_center;		/* page center (when centering is 0n, this value is 0) */
extern int right_limit;		/* right limit */
extern int left_limit;		/* left limit */

extern int max_length;		/* maximum length of PAD string */
extern int min_length;		/* minumum length of PAD string */

extern int vspace;		/* vertical spacing between boxes */
extern int hspace;		/* horizontal spacing between boxes */
extern int box_vspace;		/* vertical space of normal box */
extern int if_vspace;		/* vertical sapce of "if" box */
extern int box_hspace;		/* horizontal space of normal box */
extern int if_rightspace;	/* space of "if" box at right side */
extern int sideline_space;	/* spacing between horizontal sidelines (used in for statement and others) */
extern int box_height;		/* box height */
extern int if_height;		/* "if" box height */
extern int pad_vspace;		/* vertical spacing between PADs */
extern int padframe_vspace;	/* vertical spacing between PAD and its frame */
extern int padframe_hspace;	/* horizontal spacing between PAD and it frame */

extern int linewidth;		/* thickness of line */
extern int padlinewidth;	/* thickness of PAD figure */
extern int framelinewidth;	/* thickness of PAD frame */

extern int fontsize;		/* font size (height of characters) */
extern int fontwidth;		/* width of font (alphabets) */
extern int jfontwidth;		/* width of font (japanese characters) */
extern double title_rate;	/* magnification rate of title */
extern double padtitle_rate;	/* magnification rate of PAD title */
extern double figure_rate;	/* magnification rate of PAD figure */

extern char font[];		/* font */
extern char title_font[];	/* title font */
#ifdef JAPANESE
extern char jfont[];		/* Japanese font */
extern char title_jfont[];	/* Japanese font for title */
#endif

extern double vrate;		/* magnification rate (vertical) */
extern double hrate;		/* magnification rate (horizontal) */

extern double proper_hrate;	/* appropriate hrate value */

extern int first_x;		/* the starting x-coordinate */
extern int next_y;		/* the following PAD's y-coordinate */

extern int most_right;		/* the rightmost PAD's x-coordinate */
extern int most_left;		/* the leftmost PAD's x-coordinate */

extern PAD *root;		/* root of the tree structure */
extern PAD *current;		/* current position of the tree structure */
extern BOX *first;		/* beginning of the list */
extern BOX *lp;			/* current position oof the list */

extern bool print_warning;	/* whether to print warning */
extern int line_count;		/* line in process */

extern FILE *input_stream;	/* input file */
extern FILE *fp;		/* output file */
extern char outfile[];		/* output file name */
extern char outdir[];		/* directory to put output file */


/* fold.c */
extern void fold(void);			/* auto-fold PAD figure */
extern void refold_pad(PAD *,int);	/* refold PAD */
extern int is_box(PAD *);		/* PAD box? */

/* font.c */
extern void change_font(double);	/* change font */
extern void restore_font(void);		/* resume font */

/* locate.c */
extern void locate(void);	/* locate PAD */

/* parser.l */
extern void parser(void);	/* lexical & syntax analysis */

/* ps.c */
extern void ps(void);		/* create PostScript */

/* sort.c */
extern void sort(void);		/* sort box-typed data */

/* string.c */
extern STRING *string(char *,int,int,int);	/* create STRING-type data */
extern int get_str_ww(char *);			/* return string width */
extern int get_str_width(PAD *);		/* return string width after folding */
extern int get_str_height(PAD *);		/* return string height after folding */
extern int get_str_lines(PAD *,int);		/* return line number after folding with given width */

/* tex.c */
extern void tex(void);		/* create LaTeX code */

#endif  /* ! _PAD2PS_H */
