/*                           */
/*  stack.c -- handle stack  */
/*                           */
/*  by S. Yoshida            */
/*                           */

#include "config.h"

#ifdef HAVE_MALLOC_H
# include <malloc.h>
#endif
#include "lib.h"

static STACK *sp = NULL;

void push(void *ptr)
{
    STACK *tmp;

    tmp = (STACK *)malloc(sizeof(STACK));
    tmp->ptr = ptr;
    tmp->prev = sp;
    sp = tmp;
}

void *pop(void)
{
    void *ptr;
    STACK *s;

    ptr = sp->ptr;
    s = sp;
    sp = sp->prev;
    free(s);
    return ptr;
}
