/*                         */
/*  lib.h                  */
/*                         */
/*  pad2ps  by S. Yoshida  */
/*                         */

#ifndef _LIB_H
#define _LIB_H

#include "config.h"

#include <stdio.h>

typedef struct _STACK STACK;

typedef enum {
    On, Off, None
} bool;

struct _STACK {
    void *ptr;
    STACK *prev;
};

extern int warning_count;	/* warning count */
extern int error_count;		/* error count */

#define greater(x,y)	((x)>=(y)? (x):(y))	/* return greater value */
#define smaller(x,y)	((x)<=(y)? (x):(y))	/* return smaller value */

/* error.c */
extern void error(char *);		/* print error messages */
extern void warning(char *);		/* print warnings */
extern void fatal_error(char *);	/* print error messagea and exit */

/* stack.c */
extern void push(void *);
extern void *pop(void);

/* string.c */
extern char *joint(int,char *,...);	/* concatenate strings */
extern int is_euc(char);		/* Japanese character? */
extern int include_euc(char *);		/* include Japanese characters? */

#endif  /* ! _LIB_H */
