/*                             */
/*  error.c -- handling errors */
/*                             */
/*  by S. Yoshida              */
/*                             */

#include "config.h"

#include <stdlib.h>
#include "lib.h"

int warning_count = 0;		/* warning count */
int error_count = 0;		/* error count */

void error(char *message)
{
    error_count++;
    fprintf(stderr,"\n%s ",message);
}

void warning(char *message)
{
    warning_count++;
    if(message != NULL)
        fprintf(stderr,"\nwarning: %s ",message);
}

void fatal_error(char *message)
{
    fprintf(stderr,"\n%s\n",message);
    exit(1);
}
