/*                           */
/*  java2pad.h               */
/*                           */
/*  java2pad  by S. Yoshida  */
/*                           */

#ifndef _JAVA2PAD_H
#define _JAVA2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* output in English by default */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"


typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num,
    Lpar, Rpar, Lbrace, Rbrace, Lbracket, Rbracket,
    Colon, Colon2, Semicolon,
    Question,
    Equal, Equal2, Neq, Less, Great, Less_eq, Great_eq,
    Not, And, Or, And2, Or2,
    Plus, Minus, Times, Divide, Exp, Lshift, Rshift,
    If, Else, While, For, Do, Switch, Case, Default, Try, Catch,
    Return, Break, Continue, Goto
} token_type;


extern token_type token;	/* token */
extern char word[];		/* string just read */

extern bool no_print_comment_flag;	/* do not print comment at this place */
extern bool elseif_flag;                /* whether in middle of processing else if */

extern int tab;			/* tab width */
extern bool optimize;		/* -O option */
extern bool semicolon;		/* -semicolon option */

extern bool debug;		/* -debug option */
extern bool quiet;		/* -quiet option */
extern bool print_warning;	/* whether to print warning */
extern int line_count;		/* line in process */

extern FILE *input_stream;	/* input file */


/* parser.c */
extern void parser(void);		/* output */

/* token.c */
extern void get_token(void);		/* get token */

#endif  /* ! _JAVA2PAD_H */
