/*                                */
/*  java2pad.c -- main routine    */
/*                                */
/*  java2pad  by S. Yoshida       */
/*                                */

#include "config.h"

#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include "java2pad.h"

token_type token = None;	/* token */
char word[BUFSIZ] = {'\0'};	/* string just read */

bool no_print_comment_flag = Off;	/* do not print comment at this place */
bool elseif_flag = Off;                 /* whether in middle of processing else if */

int tab = 4;			/* tab width */
bool optimize = Off;		/* -O option */
bool semicolon = Off;		/* -semicolon option */

bool debug = Off;		/* -debug option */
bool quiet = Off;		/* -quiet option */
bool print_warning = Off;	/* whether to print warning */
int line_count = 1;		/* line in process */

FILE *input_stream;		/* input file */


#ifdef JAPANESE
static char kconv[BUFSIZ] = "nkf -e";	/* KANJI converter */
static bool noconv = Off;		/* -noconv */
#endif
static bool nohelp = Off;		/* -nohelp */
static bool stdin_flag = Off;		/* -stdin */

static char filename[BUFSIZ] = {'\0'};		/* name of input file */
static char command[BUFSIZ];			/* command */

static char prepfile[BUFSIZ];		/* file name after treating pre-processor */

static void prep(void);			/* pre-processor (treat "\" at the end of line) */
static int p_getchar(FILE *);		/* get one character */

static void option(int,char **);	/* handle options */
static void print_help(void);		/* print help messages */

#if defined(HAVE_ATEXIT)
static void at_exit(void);		/* handle termination process */
#elif defined(HAVE_ON_EXIT)
static void at_exit(int,void *);	/* handle termination process */
#endif

int main(int argc,char **argv)
{
    char tmp[BUFSIZ];
    char *env;

    /* handle exit() process */
#if defined(HAVE_ATEXIT)
    atexit(at_exit);
#elif defined(HAVE_ON_EXIT)
    on_exit(at_exit,NULL);
#endif

    /* file name after treating pre-processor */
#ifdef TMP
    strcpy(prepfile,TMP);
    strcat(prepfile,"/");
#else
    strcpy(prepfile,"/tmp/");
#endif
    if((env = getenv("TMP")) != NULL  &&  strlen(env) > 0){
	/* get the environment variable TMP */
	strcpy(prepfile,env);
	strcat(prepfile,"/");
    }
    strcat(prepfile,"java2pad-XXXXXX");

    option(argc,argv);			/* handle options */

    if(quiet == Off)
	fprintf(stderr,"\njava2pad %s  by %s\n\n",VERSION,AUTHOR);

    if(stdin_flag == On)
	filename[0] = '\0';

#ifdef JAPANESE
    if(noconv == Off)
	sprintf(command,"cat %s | %s",filename,kconv);
    else
#endif
	sprintf(command,"cat %s",filename);

    input_stream = popen(command,"r");

    mktemp(prepfile);

    prep();		/* pre-processor (treat "\" at the end of line) */

    pclose(input_stream);

    input_stream = fopen(prepfile,"r");

    parser();

    fclose(input_stream);

    remove(prepfile);

    if(quiet == Off)
	fprintf(stderr,"\n%d errors, %d warnings.\n",error_count,warning_count);

    return 0;
}

void prep(void)
/* pre-processor (treat "\" at the end of line) */
{
    FILE *fp;
    int ch;
    int pch = 0;

    fp = fopen(prepfile,"w");

    ch = p_getchar(input_stream);
    while(ch != EOF){
	if(ch == '\\'){
	    ch = p_getchar(input_stream);
	    if(ch != '\n'){
		fputc('\\',fp);
		fputc(ch,fp);
	    }
	}else
	    fputc(ch,fp);
	pch = ch;
	ch = p_getchar(input_stream);
    }

    fclose(fp);
}

int p_getchar(FILE *fp)
/* get a character */
{
    int c = 0;
    while(((0 <= c  &&  c < ' '  &&  c != '\t'  &&  c != '\n')  ||  c == 0x7F)  &&  c != EOF){
	c = getc(fp);
    }
    return c;
}

void option(int argc,char **argv)
/* handle options */
{
    int i,p;
    char *ptr;

    for(i = 1 ; i < argc ; i++){
	if(argv[i][0] != '-'){		/* file name */
	    if(filename[0] == '\0')
		strcpy(filename,argv[i]);
	    else if(nohelp == Off){
		print_help();
		exit(1);
	    }
	}else{				/* options */
	    switch(argv[i][1]){
#ifdef DEBUG
		case 'd':
		    if(strcmp(argv[i],"-debug") == 0){
			debug = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#endif
		case 'h':
		    if(strcmp(argv[i],"-help") == 0){
			print_help();
			exit(0);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#ifdef JAPANESE
		case 'k':
		    if(strcmp(argv[i],"-kconv") == 0  &&  i + 1 < argc){
			strcpy(kconv,argv[++i]);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#endif
		case 'n':
		    if(strcmp(argv[i],"-nohelp") == 0){
			nohelp = On;
		    }else if(strcmp(argv[i],"-noopt") == 0){
			optimize = Off;
#ifdef JAPANESE
		    }else if(strcmp(argv[i],"-noconv") == 0){
			noconv = On;
#endif
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'O':
		    if(strcmp(argv[i],"-O") == 0){
			optimize = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'q':
		    if(strcmp(argv[i],"-quiet") == 0){
			quiet = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 's':
		    if(strcmp(argv[i],"-semicolon") == 0){
			semicolon = On;
		    }else if(strcmp(argv[i],"-stdin") == 0){
			stdin_flag = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 't':
		    if(strcmp(argv[i],"-tab") == 0){
			i++;
			tab = atoi(argv[i]);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'w':
		    if(strcmp(argv[i],"-warn") == 0){
			print_warning = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		default:
		    if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
	    }
	}
    }
}

void print_help(void)
{
    fprintf(stderr,"\njava2pad %s  by %s\n\n",VERSION,AUTHOR);
    fputs("usage: java2pad [filename] [options]\n",stderr);
#ifdef DEBUG
    fputs("-debug                  Print parser debug message.\n",stderr);
#endif
    fputs("-help                   Print help message.\n",stderr);
#ifdef JAPANESE
    fputs("-kconv converter        Kanji code converter [default: \"nkf -e\"].\n",stderr);
    fputs("-noconv                 Do not convert kanji code.\n",stderr);
#endif
    fputs("-nohelp                 Do not print help message.\n",stderr);
    fputs("-noopt                  No optimizing.\n",stderr);
    fputs("-O                      Optimizing.\n",stderr);
    fputs("-quiet                  Do not print messages.\n",stderr);
    fputs("-semicolon              Print ';' at EOL.\n",stderr);
    fputs("-stdin                  Input from stdin.\n",stderr);
    fputs("-tab width              Set TAB width [default: 4].\n",stderr);
    fputs("-warn                   Print warnings.\n",stderr);
}


#if defined(HAVE_ATEXIT) || defined(HAVE_ON_EXIT)
#if defined(HAVE_ATEXIT)
void at_exit(void)
#elif defined(HAVE_ON_EXIT)
void at_exit(int val, void *p)
#endif
/* handle termination process */
{
    remove(prepfile);
}
#endif
