/*                          */
/*  csh2pad.h               */
/*                          */
/*  csh2pad  by S. Yoshida  */
/*                          */

#ifndef _CSH2PAD_H
#define _CSH2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* create output in English by default */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num, Label,
    And2, Or2, LL,
    Lpar, Rpar,
    Colon, Semicolon,
    If, Then, Else, Endif, While, Foreach, End,
    Switch, Case, Default, Breaksw, Endsw,
    Break, Continue, Goto
} token_type;


extern token_type token;	/* token */
extern char word[];		/* string just read */

extern bool no_print_comment_flag;	/* do not print comment */
extern bool elseif_flag;                /* whether in middle of processing else if */

extern int tab;			/* tab width */

extern char key[];		/* termination string in "cat << EOF" */
extern int cat_flag;		/* whether in "cat << EOF" or not */

extern bool debug;		/* -debug option */
extern bool quiet;		/* -quiet option */
extern bool print_warning;	/* whether printing warning or not */
extern int line_count;		/* line in process */

extern FILE *input_stream;	/* input file */


/* parser.c */
extern void parser(void);		/* output */

/* token.c */
extern void get_token(void);		/* get token */

#endif  /* ! _CSH2PAD_H */
