/*                        */
/*  c2pad.h               */
/*                        */
/*  c2pad  by S. Yoshida  */
/*                        */

#ifndef _C2PAD_H
#define _C2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* output in English by default */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

#define TRUE		((void *)10)	/* #ifdef and other's value (true/false) */
#define FALSE		((void *)11)
#define ABS_FALSE	((void *)12)
#define TRUED_FALSE	((void *)13)


typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num,
    Lpar, Rpar, Lbrace, Rbrace, Lbracket, Rbracket,
    Colon, Colon2, Semicolon,
    Sharp, Question,
    Equal, Equal2, Neq, Less, Great, Less_eq, Great_eq,
    Not, And, Or, And2, Or2,
    Plus, Minus, Times, Divide, Exp, Lshift, Rshift,
    If, Else, While, For, Do, Switch, Case, Default,
    Return, Break, Continue, Goto,
    Public, Private, Protected,
    Ifdef, Ifndef, Elif, Endif, Define, Undef, Defined
} token_type;

typedef struct _DEF DEF;

struct _DEF {
    char *sym;
    int val;
    DEF *next;
};


extern token_type token;	/* token */
extern char word[];		/* string just read */

extern bool no_print_comment_flag;	/* do not print comment */
extern bool elseif_flag;                /* whether in middle of processing else if */

extern int tab;			/* tab width */
extern bool optimize;		/* -O option */
extern bool semicolon;		/* -semicolon option */
extern bool inline_flag;	/* -inline option */

extern bool ifdef;		/* -ifdef option */

extern DEF *defined_list;	/* list of defined symbol */
extern void *ifdef_value;	/* current #ifdef value */

extern bool debug;		/* -debug option */
extern bool quiet;		/* -quiet option */
extern bool print_warning;	/* whether to print warning or not */
extern int line_count;		/* line in process */

extern FILE *input_stream;	/* input file */


/* ifdef.c */
extern void list_defines(void);		/* print list of symbols to be dealt with #ifdef */
extern void eval_ifdef(void);		/* evaluate #ifdef */
extern void add_symbol(char *,int);	/* add newly defined symbols */

/* parser.c */
extern void parser(void);		/* output */

/* token.c */
extern void get_token(void);		/* get token */

#endif  /* ! _C2PAD_H */
