/*                          */
/*  awk2pad.h               */
/*                          */
/*  awk2pad  by S. Yoshida  */
/*                          */

#ifndef _AWK2PAD_H
#define _AWK2PAD_H

#include "config.h"

#ifndef JAPANESE
#ifndef ENGLISH
#define ENGLISH		/* output in English by default */
#endif
#endif

#include <stdio.h>
#include "lib.h"
#include "version.h"

typedef enum {
    Nontoken, Eof, Comment,
    Ret, Sp,
    Str, Name, Num,
    Lpar, Rpar, Lbrace, Rbrace,
    Semicolon,
    If, Else, While, Do, For
} token_type;


extern token_type token;	/* token */
extern char word[];		/* string just read */

extern bool no_print_comment_flag;	/* do not print comment */
extern bool elseif_flag;                /* whether in middle of processing else if */ 

extern int tab;			/* tab width */

extern bool debug;		/* -debug option */
extern bool quiet;		/* -quiet option */
extern bool print_warning;	/* whether to print warning or no */
extern int line_count;		/* line in process */

extern FILE *input_stream;	/* input file */


/* parser.c */
extern void parser(void);		/* output */

/* token.c */
extern void get_token(void);		/* get toke */

#endif  /* ! _CSH2PAD_H */
