/*                               */
/*  awk2pad.c -- main routine    */
/*                               */
/*  awk2pad  by S. Yoshida       */
/*                               */

#include "config.h"

#include <stdlib.h>
#include <string.h>
#include "awk2pad.h"

token_type token = None;	/* token */
char word[BUFSIZ] = {'\0'};	/* string read */

bool no_print_comment_flag = Off;	/* do not print comment */
bool elseif_flag = Off;                 /* whether in middle of processing else if */

int tab = 4;			/* tab width */

bool debug = Off;		/* -debug option */
bool quiet = Off;		/* -quiet option */
bool print_warning = Off;	/* whether to print warning or not */
int line_count = 1;		/* line in process */

FILE *input_stream;		/* input file */


#ifdef JAPANESE
static char kconv[BUFSIZ] = "nkf -e";	/* KANJI converter */
static bool noconv = Off;		/* -noconv */
#endif
static bool nohelp = Off;		/* -nohelp */
static bool stdin_flag = Off;		/* -stdin */

static char filename[BUFSIZ] = {'\0'};		/* name of the input file */
static char command[BUFSIZ];			/* command */

static void option(int,char **);	/* processing options */
static void print_help(void);		/* printing help messages */

int main(int argc,char **argv)
{
    option(argc,argv);			/* processing options */

    if(quiet == Off)
	fprintf(stderr,"\nawk2pad %s  by %s\n\n",VERSION,AUTHOR);

    if(stdin_flag == On)
	filename[0] = '\0';

#ifdef JAPANESE
    if(noconv == Off)
	sprintf(command,"cat %s | %s",filename,kconv);
    else
#endif
	sprintf(command,"cat %s",filename);

    input_stream = popen(command,"r");

    parser();

    fclose(input_stream);

    if(quiet == Off)
	fprintf(stderr,"\n%d errors, %d warnings.\n",error_count,warning_count);

    return 0;
}

void option(int argc,char **argv)
/* processing options */
{
    int i;

    for(i = 1 ; i < argc ; i++){
	if(argv[i][0] != '-'){		/* file name */
	    if(filename[0] == '\0')
		strcpy(filename,argv[i]);
	    else if(nohelp == Off){
		print_help();
		exit(1);
	    }
	}else{				/* options */
	    switch(argv[i][1]){
#ifdef DEBUG
		case 'd':
		    if(strcmp(argv[i],"-debug") == 0){
			debug = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#endif
		case 'h':
		    if(strcmp(argv[i],"-help") == 0){
			print_help();
			exit(0);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#ifdef JAPANESE
		case 'k':
		    if(strcmp(argv[i],"-kconv") == 0  &&  i + 1 < argc){
			strcpy(kconv,argv[++i]);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
#endif
		case 'n':
		    if(strcmp(argv[i],"-nohelp") == 0){
			nohelp = On;
#ifdef JAPANESE
		    }else if(strcmp(argv[i],"-noconv") == 0){
			noconv = On;
#endif
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'q':
		    if(strcmp(argv[i],"-quiet") == 0){
			quiet = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 's':
		    if(strcmp(argv[i],"-stdin") == 0){
			stdin_flag = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 't':
		    if(strcmp(argv[i],"-tab") == 0){
			i++;
			tab = atoi(argv[i]);
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		case 'w':
		    if(strcmp(argv[i],"-warn") == 0){
			print_warning = On;
		    }else if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
		default:
		    if(nohelp == Off){
			print_help();
			exit(1);
		    }
		    break;
	    }
	}
    }
}

void print_help(void)
{
    fprintf(stderr,"\nawk2pad %s  by %s\n\n",VERSION,AUTHOR);
    fputs("usage: awk2pad [filename] [options]\n",stderr);
#ifdef DEBUG
    fputs("-debug                  Print parser debug message.\n",stderr);
#endif
    fputs("-help                   Print help message.\n",stderr);
#ifdef JAPANESE
    fputs("-kconv converter        Kanji code converter [default: \"nkf -e\"].\n",stderr);
    fputs("-noconv                 Do not convert kanji code.\n",stderr);
#endif
    fputs("-nohelp                 Do not print help message.\n",stderr);
    fputs("-quiet                  Do not print messages.\n",stderr);
    fputs("-stdin                  Input from stdin.\n",stderr);
    fputs("-tab width              Set TAB width [default: 4].\n",stderr);
    fputs("-warn                   Print warnings.\n",stderr);
}
