.\"
.\"  pad2ps.1 -- pad2ps 3.1  1996-11-02
.\"
.\"  S. Yoshida (seiichi@muraoka.info.waseda.ac.jp)
.\"
.TH PAD2PS 1 "1996-11-02" "pad2ps 3.1"
.SH "NAME"
pad2ps  \- Draw PAD figure in PostScript format
.br
pad2tex \- Draw PAD figure in LaTeX format
.br
pad2eps \- Draw PAD figure in Encapsulated PostScript format
.SH "SYNOPSIS"
.B "pad2ps"
[ \fIinput-file-name\fP  [ \fIoutput-file-name\fP ] ]
[-awk] [-c] [-c++] [-csh] [-D \fIsymbol-name\fP[=\fIvalue\fP] ... ]
[-dir \fIdirectory\fP] [-help] [-ifdef] [-inline] [-java]
[-nohelp] [-noopt] [-O] [-P \fIparameter-variables\fP=\fIvalue\fP ... ]
[-pad] [-quiet] [-semicolon] [-sh] [-stdin] [-tab \fIvalue\fP] [-warn]
.SH "DESCRIPTION"
.I pad2ps
,
.I pad2tex
, and
.I pad2eps
convert a PAD source written in PADEL syntax into PostScript, LaTeX, 
and Encapsulated PostScript (EPS) format.
.I pad2ps
,
.I pad2tex
,
.I pad2eps
also convert C, C++, Bourne shell, C shell, Java, and AWK programs into
PostScript, LaTeX, and EPS format.
.SH "OPTIONS"
.IP \fB\-awk\fR
.br
Specifies that the input file is the AWK program.
You do not need to set this option if the suffix of the input file is \.awk.
.PP
.IP \fB\-c\fR
.br
Specifies that the input file is the C program.
You do not need to set this option if the suffix of the input file is \.c.
.PP
.IP \fB\-c++\fR
.br
Specifies that the input file is the C++ program.
You do not need to set this option if the suffix of the input file
is \.cc, \.cpp, or \.C.
.PP
.IP \fB\-csh\fR
.br
Specifies that the input file is the C shell program.
You do not need to set this option if the suffix of the input file
is \.csh.
.PP
.IP \fB-D\fR
\fIsymbol\fP[=\fIvalue\fP] \.\.\.
.sp
This option is only valid when converting C or C++ program.
This option defines symbol name(s) used for #ifdef, #ifndef, and others.
When defining multiple symbols, list the symbols after \fB\-D\fR.
.sp
    ex. pad2ps filename -D DEBUG __linux__
.sp
The values may be attached to the symbols.  For example, 
.sp
        pad2ps filename -D MAX=100 > z.ps
.sp
is equivalent to writing,
.sp
        #define MAX 100
.sp
in filename.
.PP
.IP \fB-dir\fR
\fIdirectory\fP
.sp
When the output file name is specified for \fIpad2eps\fP and others, the files
are created in the current directory.  You should set this option if you want
to create the file in other directory.
.PP
.IP \fB\-help\fR
.br
Print the help messages.
.PP
.IP \fB\-ifdef\fR
.br
This option is only valid when converting C and C++ programs.
By setting this option, all symbols to be defined are printed.  This is 
all listing of the symbols used in #ifdef and others.
.PP
.IP \fB\-inline\fR
.br
This option is only valid when converting C++ programs.
By setting this option, PAD figures for inline functions that is defined 
inside the class definition will be drawn.  By default, only functions that
are defined outside the class definition are converted into PAD figures.
.PP
.IP \fB\-java\fR
.br
Specifies that the input file is the Java program.
You do not need to set this option if the suffix of the input file is \.java.
.PP
.IP \fB\-nohelp\fR
.br
Does not print the help messages.
This option is handy when using the command in script.
.PP
.IP \fB\-noopt\fR
.br
This option is only valid when converting C, C++, and Java programs.
This is the opposite of \fB\-O\fR option; By setting this option, everything
including the variable declarations will be printed.
.PP
.IP \fB\-O\fR
.br
This option is only valid when converting C, C++, and Java programs.
By setting this option, optimization is done.  This means variable
declarations such as:
.sp
	int i;
.sp
will not be printed in PAD.  However, the variable declarations with 
initialization, such as:
.sp
	int i=0;
.sp
will be printed in PAD.
All global variable declared at top of a C or C++ program are also
printed, regardless of whether \fB\-O\fR option is set.
.PP
.IP \fB-P\fR
\fIparameter-variable\fP=\fIvalue\fP \.\.\.
.sp
Specifies the parameter variables.
When specifing multiple variables, list the variables right after \fB\-P\fR.
.sp
    ex. pad2ps filename -P page=1 centering=on
.PP
.IP \fB\-pad\fR
.br
Specifies that the input file is written in the PAD syntax (PADEL).
When this option is specified, the suffix of the input file is ignored.
For instance, the file with the suffix .c will not be treated as C program.
.PP
.IP \fB\-quiet\fR
.br
Suspend printing messages other than error messages.
This option is handy when using the command in script.
.PP
.IP \fB\-semicolon\fR
.br
This option is only valid when converting C, C++, or Java program.
By setting this option, ';' at end of lines will be printed.
.PP
.IP \fB\-sh\fR
.br
Specifies that the input file is Bourne shell program.
You do not need to set this option if the suffix of the input file is \.sh.
.PP
.IP \fB\-stdin\fR
.br
Reads from the standard input.  When no input file name is specified, pad2ps
will automatically read from the standard input, so this option may be omitted.
But if you want to read from the standard input and want to specifies the output file
name, then yoiu need to set this option.
.PP
.IP \fB\-tab\fR
\fIvalue\fP
.sp
Sets tab width for LaTeX file created with \fIpad2tex\fP, or tab width for PADEL
file  converted by \fImkpad\fP.
.PP
.IP \fB\-warn\fR
.br
Print warnings.
.PP
.SH "PARAMETER VARIABLES"
.IP \fBtitle\fR
= \fIstring\fP
.IP " " 7
Specifies the overall title of PAD, if any.
The string may contain spaces.
By default, the file name will be the title when executed with the file name.  If executed
without file name, then no title is set by default.
.sp
    ex. /* pad2ps: title = This is a pad title. */
.PP
.IP \fBmessage\fR 8
= \fIstring\fP
.IP " " 7
Writes messages in specified position in PAD.
The message is regarded as normal statement, except that the message is not enclosed by frame.
.PP
.IP \fBcomment\fR 8
= \fIstring\fP
.IP " " 7
Specifies the comment that should be attached to a PAD box.
The comment should be written in the next line of the destination box.
In PAD figure, the comment is attached to the right of the box.
.PP
.IP \fBtexmode\fR 8
= latex | verbatim
.IP " " 7
Specifies whether the string in the original PADEL is regarded as LaTeX command or
regarded as normal string, when converting into LaTeX format with \fIpad2tex\fP.
When latex is specified the following PADEL will give you a Sigma notation:
.sp
	if ( $ \\sum_{i=0}^{\\infty} x_{i} = 0 $ ) {
.br
		$ s = \\sum_{i=0}^{\\infty} x_{i}^{2} $
.br
	}
.sp
If verbatim is specified, then the string is printed as it is.  The default setting
is verbatim.
.PP
.IP \fBcentering\fR 10
= on | off
.IP " " 7
When on is set, the output is centerized; otherwise the output is aligned to left.
The default is on.
.PP
.IP \fBlocate\fR 7
= topdown | bottomup | middle
.IP " " 7
Specifies the location format of PAD.
The default is middle.
.PP
.IP \fBpage\fR
= \fIvalue\fP
.sp
Specifies starting page where you want to print page numbers.
By default, the page numbers are not printed.  So you need to set this option 
even if you are to print page numbers from the first page.
.PP
.IP \fBfigure\fR
= \fIvalue\fP
.IP " " 7
Specifies starting number when you want to put figure numbers to each PAD figures.
By default, no figure number is put.
.PP
.IP \fBfigure_locate\fR 14
= top | bottom
.IP " " 7
Specifies the location of figure title.
Top will put the title above the PAD figure, and bottom will put below.
By default, bottom is selected when printing figure numbers; otherwise top is
selected.
.PP
.IP \fBtitlebox\fR 9
= on | off
.IP " " 7
When off is selected, each PAD's title (function name for C program) will become
the figure title for each PAD figure.
When on is selected, each PAD's title will be written inside PAD as a PAD box with
double lined sidelines. 
The default is off.
.PP
.IP \fBpageframe\fR 10
= on | off
.IP " " 7
When on is selected, each page is enclosed with frame.
By default this option is off.
.PP
.IP \fBpadframe\fR 9
= on | off
.IP " " 7
When on is selected, each PAD as a whole is enclosed with frame.
When \fBcentering\fR is on, the frame size will be aligned to PAD size; otherwise the size
is the same as the page width.
By default this option is on.
.PP
.IP \fBslice\fR
= on | off
.IP " " 7
When on is selected, each PAD is drawn at top of a new page; otherwise a PAD will be drawn
without any consideration of page boundary.
The default is off.
.PP
.IP \fBhrate\fR
= \fIvalue\fP
.IP " " 7
Specifies horizontal magnification ratio.
You can set fraction value.
The default value is 1.0.
.PP
.IP \fBvrate\fR
= \fIvalue\fP
.IP " " 7
Specifies vertical magnification ratio.
The default value is 1.0.
.PP
.IP \fBposter\fR
= on | off
.IP " " 7
When on is selected, a large PAD that would split over several pages in sideway 
is created as it is; otherwise the output will be compressed as to put the figure
in one paper.
The default setting is off.
.PP
.IP \fBmax_length\fR 11
= \fIvalue\fP
.IP " " 7
Specifies the maximum length of PAD string.
All strings longer than this value will be folded.
The default value is infinity.
.PP
.IP \fBmin_length\fR 11
= \fIvalue\fP
.IP " " 7
Specifies the minimum length of PAD string.
No string will be shorter than this value when folded.
The default value is 0.
.PP
.IP \fBnewpage\fR
.sp
Insert page break at specified location.
.PP
.IP \fBvsp\fR
= \fIvalue\fP
.IP " " 7
Put vertical spacing at specified location.
You can freely set the amount of spaces to be put.
When negative number is specified, the interval between PADs is lessened.
Unlike adding empty lines, you can put spaces at head of a program.
.PP
.IP "PAGE SIZE"
.IP \fBpage_top\fR 9
= \fIvalue\fP
.IP " " 7
Specifies the coordinate of top of a page.
The default value is 9800.
The value may range from 0 to 10000.
.PP
.IP \fBpage_bottom\fR 12
= \fIvalue\fP
.IP "  " 7
Specifies the coordinate of a bottom of a page.
The default value is 0.
You cannot chage the location of page number by changing this value, though.
.PP
.IP \fBpage_left\fR 10
= \fIvalue\fP
.IP " " 7
Specifies the coordinate of a left of a page.
This value is used for aligning PAD when \fBcentering\fR is off.
When \fBcentering\fR is on, this value is ignored
The default value is 500.
The value may range from 0 to 9000.
.PP
.IP \fBpage_right\fR 11
= \fIvalue\fP
.IP " " 7
Specifies the coordinate of a right of a page.
This value is ignored when \fBcentering\fR is on.
The default value is 8500.
.PP
.IP "FONT SIZE"
.IP \fBfontsize\fR 9
= \fIvalue\fP
.IP " " 7
Specifies the height of the font.
The default value is 200
.PP
.IP \fBfontwidth\fR 10
= \fIvalue\fP
.IP " " 7
Specifies the width of the alphabets font.
The default value is 100.
.PP
.IP \fBtitle_rate\fR 11
= \fIvalue\fP
.IP " " 7
Specifies the magnification ratio of the overall title font to the normal font.
The default value is 2.0.
.PP
.IP \fBpadtitle_rate\fR 14
= \fIvalue\fP
.IP " " 7
Specifies the magnification ratio of the PAD title font to the normal font.
The default value is 1.5.
This value is ignored when printing figure number.
.PP
.IP \fBfigure_rate\fR 12
= \fIvalue\fP
.IP " " 7
Specifies the magnification ratio of the PAD figure title font to the normal font.
The default value is 1.5.
This value is only valid when printing figure number.
.PP
.IP "SPACES"
.IP \fBpad_vspace\fR 16
= \fIvalue\fP ( 400 )
.IP \fBvspace\fR 16
= \fIvalue\fP ( 120 )
.IP \fBhspace\fR 16
= \fIvalue\fP ( 200 )
.IP \fBbox_vspace\fR 16
= \fIvalue\fP (  25 )
.IP \fBif_vspace\fR 16
= \fIvalue\fP (  50 )
.IP \fBbox_hspace\fR 16
= \fIvalue\fP ( 125 )
.IP \fBif_rightspace\fR 16
= \fIvalue\fP ( 200 )
.IP \fBsideline_space\fR 16
= \fIvalue\fP (  50 )
.IP \fBpadframe_vspace\fR 16
= \fIvalue\fP ( 180 )
.IP \fBpadframe_hspace\fR 16 
= \fIvalue\fP ( 300 )
.IP " " 7
Each value shows the size of spaces to be put in the corresponding places.
Set these values accordingly to make fine tunings.
The values in paranthesis are the default.
.PP
.IP "LINE THICKNESS"
.IP \fBlinewidth\fR 10
= \fIvalue\fP
.IP " " 7
Specifies the thickness of lines that connect PADs.
The default value is 16.
.PP
.IP \fBpadlinewidth\fR 13
= \fIvalue\fP
.IP " " 7
Specifies the thickness of lines used to draw PAD.
The default value is 16.
.PP
.IP \fBframelinewidth\fR 15
= \fIvalue\fP
.IP " " 7
Specifies the thickness of lines used for frames.
The default value is 8.
.PP
.SH "ENVIRONMENT VARIABLES"
.IP \fB\PAD2PSLIB\fR
.br
Specifies the path where the modules for \fIpad2ps\fP series are located.
By default, this variable is set as /usr/local/lib/pad2ps.
.PP
.IP \fB\TMP\fR
.br
Specifies the directory where temporary files are to be created.
By default, this variable is set as /tmp.
.PP
.SH "FILES"
.nf
.ta \w'/usr/local/lib/tex/macros/pad.sty__'u
/usr/local/bin/pad2*               execute files
/usr/local/bin/mkpad               translation script into PADEL
/usr/local/lib/pad2ps/pad2*        main modules
/usr/local/lib/pad2ps/*2pad        translation modules into PADEL
/usr/local/lib/tex/macros/pad.sty  style file
/usr/local/man/man1/pad2*.1        manual pages
/usr/local/man/man1/mkpad.1        manual pages
/tmp/pad2ps-XXXXXX                 temporary files
/tmp/foo2pad-XXXXXX                temporary files
/tmp/c2pad-XXXXXX                  temporary files
.SH "AUTHOR"
.nf
Seiichi Yoshida
.br
seiichi@muraoka.info.waseda.ac.jp
.br
http://www.info.waseda.ac.jp/muraoka/members/seiichi/index.html



